/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.spotify.docker.AbstractDockerMojo;
import com.spotify.docker.Utils;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.exceptions.ImageNotFoundException;
import com.spotify.docker.client.messages.Image;
import com.spotify.docker.client.messages.RemovedImage;
import com.spotify.docker.client.shaded.javax.ws.rs.NotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="removeImage")
public class RemoveImageMojo
extends AbstractDockerMojo {
    @Parameter(property="imageName", required=true)
    private String imageName;
    @Parameter(property="dockerImageTags")
    private List<String> imageTags;
    @Parameter(property="removeAllTags", defaultValue="false")
    private boolean removeAllTags;

    @Override
    protected void execute(DockerClient docker) throws MojoExecutionException, DockerException, InterruptedException {
        String[] imageNameParts = Utils.parseImageName(this.imageName);
        if (this.imageTags == null) {
            this.imageTags = new ArrayList<String>(1);
            this.imageTags.add(imageNameParts[1]);
        } else if (this.removeAllTags) {
            this.getLog().info((CharSequence)"Removal of all tags requested, searching for tags");
            for (Image currImage : docker.listImages(new DockerClient.ListImagesParam[0])) {
                this.getLog().debug((CharSequence)("Found image: " + currImage.toString()));
                if (currImage.repoTags() == null) continue;
                for (Object repoTag : currImage.repoTags()) {
                    String[] parsedRepoTag = Utils.parseImageName((String)repoTag);
                    if (!Objects.equal((Object)parsedRepoTag[0], (Object)imageNameParts[0])) continue;
                    this.imageTags.add(parsedRepoTag[1]);
                    this.getLog().info((CharSequence)("Adding tag for removal: " + parsedRepoTag[1]));
                }
            }
        }
        this.imageTags.add(imageNameParts[1]);
        HashSet<String> uniqueImageTags = new HashSet<String>(this.imageTags);
        for (String imageTag : uniqueImageTags) {
            String currImageName = imageNameParts[0] + (Strings.isNullOrEmpty((String)imageTag) ? "" : ":" + imageTag);
            this.getLog().info((CharSequence)("Removing -f " + currImageName));
            try {
                for (RemovedImage removedImage : docker.removeImage(currImageName, true, false)) {
                    this.getLog().info((CharSequence)("Removed: " + removedImage.imageId()));
                }
            }
            catch (ImageNotFoundException | NotFoundException e) {
                this.getLog().warn((CharSequence)("Image " + this.imageName + " doesn't exist and cannot be deleted - ignoring"));
            }
        }
    }
}

