/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.plugin.dockerfile;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.messages.ProgressMessage;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.logging.Log;

class LoggingProgressHandler
implements ProgressHandler {
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n');
    private final Log log;
    private final boolean verbose;
    private String builtImageId;
    private Map<String, String> imageStatuses = new HashMap<String, String>();

    LoggingProgressHandler(Log log, boolean verbose) {
        this.log = log;
        this.verbose = verbose;
    }

    public static LoggingProgressHandler forLog(Log log, boolean verbose) {
        return new LoggingProgressHandler(log, verbose);
    }

    @Nullable
    public String builtImageId() {
        return this.builtImageId;
    }

    public void progress(ProgressMessage message) throws DockerException {
        if (message.error() != null) {
            this.handleError(message.error());
        } else if (message.progressDetail() != null) {
            this.handleProgress(message.id(), message.status(), message.progress());
        } else {
            this.handleGeneric(message.stream(), message.status());
        }
        String imageId = message.buildImageId();
        if (imageId != null) {
            this.builtImageId = imageId;
        }
    }

    void handleGeneric(@Nullable String stream, @Nonnull String status) {
        String value = stream != null ? LoggingProgressHandler.trimNewline(stream) : status;
        for (String line : LINE_SPLITTER.split((CharSequence)value)) {
            this.log.info((CharSequence)line);
        }
    }

    void handleProgress(@Nonnull String id, @Nonnull String status, @Nullable String progress) {
        if (this.verbose) {
            if (progress == null) {
                this.log.info((CharSequence)MessageFormat.format("Image {0}: {1}", id, status));
            } else {
                this.log.info((CharSequence)MessageFormat.format("Image {0}: {1} {2}", id, status, progress));
            }
        } else if (!Objects.equal((Object)this.imageStatuses.get(id), (Object)status)) {
            this.imageStatuses.put(id, status);
            this.log.info((CharSequence)MessageFormat.format("Image {0}: {1}", id, status));
        }
    }

    void handleError(@Nonnull String error) throws DockerException {
        this.log.error((CharSequence)error);
        throw new DockerException(error);
    }

    @Nonnull
    static String trimNewline(@Nonnull String string) {
        if (string.endsWith("\n")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }
}

