/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.plugin.dockerfile;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.auth.ConfigFileRegistryAuthSupplier;
import com.spotify.docker.client.auth.MultiRegistryAuthSupplier;
import com.spotify.docker.client.auth.RegistryAuthSupplier;
import com.spotify.docker.client.auth.gcr.ContainerRegistryAuthSupplier;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public abstract class AbstractDockerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", property="dockerfile.outputDirectory", required=true)
    private File buildDirectory;
    @Parameter(defaultValue="${project.build.directory}/docker", property="dockerfile.dockerInfoDirectory", required=true)
    protected File dockerInfoDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", property="dockerfile.testOutputDirectory", required=true)
    protected File testOutputDirectory;
    @Parameter(defaultValue="300000", property="dockerfile.readTimeoutMillis", required=true)
    protected long readTimeoutMillis;
    @Parameter(defaultValue="300000", property="dockerfile.connectTimeoutMillis", required=true)
    protected long connectTimeoutMillis;
    @Parameter(defaultValue="1", property="dockerfile.retryCount")
    protected int retryCount;
    @Parameter(defaultValue="false", property="dockerfile.verbose")
    protected boolean verbose;
    @Parameter(defaultValue="false", property="dockerfile.skip")
    protected boolean skip;
    @Parameter(defaultValue="true", property="dockerfile.writeTestMetadata")
    protected boolean writeTestMetadata;
    @Parameter(defaultValue="false", property="dockerfile.forceCreation")
    private boolean forceCreation;
    @Parameter(defaultValue="${project.build.finalName}", property="dockerfile.finalName")
    private String finalName;
    @Parameter(defaultValue="docker-info", property="dockerfile.classifier")
    protected String classifier;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Component
    private MavenProjectHelper projectHelper;

    protected abstract void execute(DockerClient var1) throws MojoExecutionException, MojoFailureException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution because 'dockerfile.skip' is set");
        } else {
            this.tryExecute(this.retryCount + 1);
        }
    }

    private void tryExecute(int attempts) throws MojoFailureException, MojoExecutionException {
        Preconditions.checkArgument((attempts > 0 ? 1 : 0) != 0, (Object)"attempts must not be negative");
        MojoExecutionException exception = null;
        for (int attempt = 0; attempt < attempts; ++attempt) {
            try {
                this.execute(this.openDockerClient());
                return;
            }
            catch (MojoExecutionException e) {
                exception = e;
                int attemptsLeft = attempts - attempt - 1;
                if (attemptsLeft <= 0) continue;
                String warningMessage = MessageFormat.format("An attempt failed, will retry {0} more times", attemptsLeft);
                this.getLog().warn((CharSequence)warningMessage, (Throwable)e);
                continue;
            }
        }
        throw exception;
    }

    protected void writeMetadata(Log log) throws MojoExecutionException {
        this.writeTestMetadata();
        File jarFile = this.buildDockerInfoJar(log);
        this.attachJar(jarFile);
    }

    protected void writeMetadata(@Nonnull Metadata metadata, @Nonnull String value) throws MojoExecutionException {
        File metadataFile = this.ensureMetadataFile(metadata);
        String oldValue = this.readMetadata(metadata);
        if (Objects.equals(oldValue, value)) {
            return;
        }
        try {
            Files.write((CharSequence)(value + "\n"), (File)metadataFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            String message = MessageFormat.format("Could not write {0} file at {1}", metadata.getFriendlyName(), metadataFile);
            throw new MojoExecutionException(message, (Exception)e);
        }
    }

    private void writeTestMetadata() throws MojoExecutionException {
        if (this.writeTestMetadata && this.dockerInfoDirectory.exists()) {
            File testMetadataDir = new File(this.testOutputDirectory, this.getMetaSubdir());
            if (!testMetadataDir.isDirectory() && !testMetadataDir.mkdirs()) {
                throw new MojoExecutionException("Could not create metadata output directory");
            }
            for (String name : this.dockerInfoDirectory.list()) {
                File sourceFile = new File(this.dockerInfoDirectory, name);
                File targetFile = new File(testMetadataDir, name);
                try {
                    Files.copy((File)sourceFile, (File)targetFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not copy files", (Exception)e);
                }
            }
        }
    }

    private String getMetaSubdir() {
        return String.format("META-INF/docker/%s/%s/", this.project.getGroupId(), this.project.getArtifactId());
    }

    void attachJar(@Nonnull File jarFile) {
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, "docker-info", this.classifier, jarFile);
        } else {
            this.project.getArtifact().setFile(jarFile);
        }
    }

    @Nonnull
    protected File buildDockerInfoJar(@Nonnull Log log) throws MojoExecutionException {
        File jarFile = AbstractDockerMojo.getJarFile(this.buildDirectory, this.finalName, this.classifier);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        this.archive.setForced(this.forceCreation);
        if (this.dockerInfoDirectory.exists()) {
            String prefix = this.getMetaSubdir();
            archiver.getArchiver().addDirectory(this.dockerInfoDirectory, prefix);
        } else {
            log.warn((CharSequence)"Docker info directory not created - Docker info JAR will be empty");
        }
        try {
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not build Docker info JAR", e);
        }
        return jarFile;
    }

    @Nonnull
    private static File getJarFile(@Nonnull File basedir, @Nonnull String finalName, @Nullable String classifier) {
        if ((classifier = classifier == null ? "" : classifier.trim()).length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".jar");
    }

    @Nonnull
    protected File ensureDockerInfoDirectory() throws MojoExecutionException {
        if (!this.dockerInfoDirectory.exists() && !this.dockerInfoDirectory.mkdirs()) {
            throw new MojoExecutionException(MessageFormat.format("Could not create Docker info directory {0}", this.dockerInfoDirectory));
        }
        return this.dockerInfoDirectory;
    }

    @Nonnull
    protected File ensureMetadataFile(@Nonnull Metadata metadata) throws MojoExecutionException {
        return new File(this.ensureDockerInfoDirectory(), metadata.getFileName());
    }

    protected void writeImageInfo(String repository, String tag) throws MojoExecutionException {
        this.writeMetadata(Metadata.REPOSITORY, repository);
        this.writeMetadata(Metadata.TAG, tag);
        this.writeMetadata(Metadata.IMAGE_NAME, AbstractDockerMojo.formatImageName(repository, tag));
    }

    @Nullable
    protected String readMetadata(@Nonnull Metadata metadata) throws MojoExecutionException {
        File metadataFile = this.ensureMetadataFile(metadata);
        if (!metadataFile.exists()) {
            return null;
        }
        try {
            return Files.readFirstLine((File)metadataFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            String message = MessageFormat.format("Could not read {0} file at {1}", metadata.getFileName(), metadataFile);
            throw new MojoExecutionException(message, (Exception)e);
        }
    }

    @Nonnull
    protected static String formatImageName(@Nonnull String repository, @Nonnull String tag) {
        return repository + ":" + tag;
    }

    @Nonnull
    private DockerClient openDockerClient() throws MojoExecutionException {
        RegistryAuthSupplier authSupplier = this.createRegistryAuthSupplier();
        try {
            return DefaultDockerClient.fromEnv().readTimeoutMillis(this.readTimeoutMillis).connectTimeoutMillis(this.connectTimeoutMillis).registryAuthSupplier(authSupplier).build();
        }
        catch (DockerCertificateException e) {
            throw new MojoExecutionException("Could not load Docker certificates", (Exception)((Object)e));
        }
    }

    @Nonnull
    private RegistryAuthSupplier createRegistryAuthSupplier() {
        ArrayList<Object> suppliers = new ArrayList<Object>();
        suppliers.add(new ConfigFileRegistryAuthSupplier());
        try {
            RegistryAuthSupplier googleSupplier = this.googleContainerRegistryAuthSupplier();
            if (googleSupplier != null) {
                suppliers.add(0, googleSupplier);
            }
        }
        catch (IOException ex) {
            this.getLog().info((CharSequence)"ignoring exception while loading Google credentials", (Throwable)ex);
        }
        return new MultiRegistryAuthSupplier(suppliers);
    }

    @Nullable
    private RegistryAuthSupplier googleContainerRegistryAuthSupplier() throws IOException {
        File file;
        GoogleCredentials credentials = null;
        String googleCredentialsPath = System.getenv("DOCKER_GOOGLE_CREDENTIALS");
        if (googleCredentialsPath != null && (file = new File(googleCredentialsPath)).exists()) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                credentials = GoogleCredentials.fromStream((InputStream)inputStream);
                this.getLog().info((CharSequence)("Using Google credentials from file: " + file.getAbsolutePath()));
            }
        }
        if (credentials == null) {
            try {
                credentials = GoogleCredentials.getApplicationDefault();
                this.getLog().info((CharSequence)"Using Google application default credentials");
            }
            catch (IOException ex) {
                this.getLog().debug((CharSequence)"Failed to load Google application default credentials", (Throwable)ex);
            }
        }
        if (credentials == null) {
            return null;
        }
        return ContainerRegistryAuthSupplier.forCredentials((GoogleCredentials)credentials).build();
    }

    protected static enum Metadata {
        IMAGE_ID("image ID", "image-id"),
        REPOSITORY("repository", "repository"),
        TAG("tag", "tag"),
        IMAGE_NAME("image name", "image-name");

        private final String friendlyName;
        private final String fileName;

        private Metadata(String friendlyName, String fileName) {
            this.friendlyName = friendlyName;
            this.fileName = fileName;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

