package com.spotify.flo.examples;

import io.rouz.flo.Task;
import io.rouz.flo.TaskConstructor;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Generated;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;

@Generated("io.rouz.flo.processor.TaskBindingProcessor")
public final class FloRootTaskFactory {
  private FloRootTaskFactory() {
    // no instantiation;
  }

  public static TaskConstructor<Long> Simple_Fib() {
    return new Simple_Fib();
  }

  private static void opt(String name, Class type, OptionParser parser) {
    final boolean isFlag = boolean.class.equals(type);
    final OptionSpecBuilder spec = (isFlag)
         ? parser.accepts(name, "(default: false)")
         : parser.accepts(name);

    if (!isFlag) {
      spec.withRequiredArg().ofType(type).describedAs(name).required();
    }
  }

  private static final class Simple_Fib implements TaskConstructor<Long> {
    @Override
    public String name() {
      return "Simple.fib";
    }

    @Override
    public Task<Long> create(String... args) {
      final OptionParser parser = parser();
      final OptionSet parse = parser.parse(args);

      final long n = (long) Objects.requireNonNull(parse.valueOf("n"));

      return Simple.fib(n);
    }

    public OptionParser parser() {
      final OptionParser parser = new OptionParser();

      opt("n", long.class, parser);

      parser.acceptsAll(Arrays.asList("h", "help")).forHelp();

      return parser;
    }
  }
}
