/*-
 * -\-\-
 * examples
 * --
 * Copyright (C) 2016 Spotify AB
 * --
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * -/-/-
 */

package com.spotify.flo.examples;

import static java.util.Arrays.asList;

import com.spotify.flo.context.FloRunner;
import io.rouz.flo.Task;
import io.rouz.flo.TaskBuilder;
import io.rouz.flo.processor.RootTask;

/**
 * Simple Fibonacci Task
 */
public class Simple {

  @RootTask
  static Task<Long> fib(long n) {
    TaskBuilder<Long> builder = Task.named("fib", n).ofType(Long.class);

    if (n < 2) {
      return builder
          .process(() -> n);
    } else {
      return builder
          .in(() -> fib(n - 1))
          .in(() -> fib(n - 2))
          .process((a, b) -> a + b);
    }
  }

  static Task<Integer> monthHalfs(int half) {
    return Task.named("month-halfs", half).ofType(Integer.class)
        .process(() -> half);
  }

  static Task<Integer> weekOfMonth(int i) {
    return Task.named("week-of-month", i).ofType(Integer.class)
//        .meta("key", "value")
        .in(() -> monthHalfs(i / 2))
        .process((half) -> i + half);
  }

  public static void main(String[] args) {

    Task<Integer> w0 = weekOfMonth(0);
    Task<Integer> w1 = weekOfMonth(1);
    Task<Integer> w2 = weekOfMonth(2);
    Task<Integer> w3 = weekOfMonth(3);

    Task<Long> join = Task.named("join").ofType(Long.class)
        .ins(() -> asList(w0, w1, w2, w3))
        .in(() -> fib(7))
        .process((ws,f) -> ws.stream().mapToInt(i -> i).sum() + f);

    FloRunner.runTask(join, args);
  }
}
