/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http;

import com.spotify.ffwd.http.fasterxml.jackson.annotation.JsonCreator;
import com.spotify.ffwd.http.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.spotify.ffwd.http.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Batch {
    private final Map<String, String> commonTags;
    private final List<Point> points;

    @JsonCreator
    public Batch(@JsonProperty(value="commonTags") Map<String, String> commonTags, @JsonProperty(value="points") List<Point> points) {
        this.commonTags = commonTags;
        this.points = points;
    }

    public Map<String, String> getCommonTags() {
        return this.commonTags;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Batch)) {
            return false;
        }
        Batch other = (Batch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$commonTags = this.getCommonTags();
        Map<String, String> other$commonTags = other.getCommonTags();
        if (this$commonTags == null ? other$commonTags != null : !((Object)this$commonTags).equals(other$commonTags)) {
            return false;
        }
        List<Point> this$points = this.getPoints();
        List<Point> other$points = other.getPoints();
        return !(this$points == null ? other$points != null : !((Object)this$points).equals(other$points));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Batch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $commonTags = this.getCommonTags();
        result = result * 59 + ($commonTags == null ? 43 : ((Object)$commonTags).hashCode());
        List<Point> $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        return result;
    }

    public String toString() {
        return "Batch(commonTags=" + this.getCommonTags() + ", points=" + this.getPoints() + ")";
    }

    public static class Point {
        private final String key;
        private final Map<String, String> tags;
        private final double value;
        private final long timestamp;

        public Point(@JsonProperty(value="key") String key, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="value") double value, @JsonProperty(value="timestamp") long timestamp) {
            this.key = key;
            this.tags = tags;
            this.value = value;
            this.timestamp = timestamp;
        }

        public String getKey() {
            return this.key;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public double getValue() {
            return this.value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Point)) {
                return false;
            }
            Point other = (Point)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Map<String, String> this$tags = this.getTags();
            Map<String, String> other$tags = other.getTags();
            if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
                return false;
            }
            if (Double.compare(this.getValue(), other.getValue()) != 0) {
                return false;
            }
            return this.getTimestamp() == other.getTimestamp();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Point;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Map<String, String> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            long $value = Double.doubleToLongBits(this.getValue());
            result = result * 59 + (int)($value >>> 32 ^ $value);
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            return result;
        }

        public String toString() {
            return "Batch.Point(key=" + this.getKey() + ", tags=" + this.getTags() + ", value=" + this.getValue() + ", timestamp=" + this.getTimestamp() + ")";
        }
    }
}

