/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http;

import com.spotify.ffwd.http.okhttp3.Interceptor;
import com.spotify.ffwd.http.okhttp3.MediaType;
import com.spotify.ffwd.http.okhttp3.Request;
import com.spotify.ffwd.http.okhttp3.RequestBody;
import com.spotify.ffwd.http.okhttp3.Response;
import com.spotify.ffwd.http.okio.Buffer;
import com.spotify.ffwd.http.okio.BufferedSink;
import com.spotify.ffwd.http.okio.GzipSink;
import com.spotify.ffwd.http.okio.Okio;
import java.io.IOException;

class GzipRequestInterceptor
implements Interceptor {
    GzipRequestInterceptor() {
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (request.body() == null || request.header("Content-Encoding") != null) {
            return chain.proceed(request);
        }
        Request compressedRequest = request.newBuilder().header("Content-Encoding", "gzip").method(request.method(), this.compress(request.body())).build();
        return chain.proceed(compressedRequest);
    }

    private RequestBody compress(final RequestBody body) throws IOException {
        final Buffer buffer = new Buffer();
        try (BufferedSink gzipSink = Okio.buffer(new GzipSink(buffer));){
            body.writeTo(gzipSink);
        }
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return body.contentType();
            }

            @Override
            public long contentLength() {
                return buffer.size();
            }

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(buffer.snapshot());
            }
        };
    }
}

