/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http;

import com.spotify.ffwd.http.Batch;
import com.spotify.ffwd.http.GzipRequestInterceptor;
import com.spotify.ffwd.http.HttpDiscovery;
import com.spotify.ffwd.http.HttpPing;
import com.spotify.ffwd.http.RawHttpClientFactory;
import com.spotify.ffwd.http.RetryWithDelay;
import com.spotify.ffwd.http.fasterxml.jackson.databind.DeserializationFeature;
import com.spotify.ffwd.http.fasterxml.jackson.databind.ObjectMapper;
import com.spotify.ffwd.http.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.spotify.ffwd.http.netflix.loadbalancer.AvailabilityFilteringRule;
import com.spotify.ffwd.http.netflix.loadbalancer.ILoadBalancer;
import com.spotify.ffwd.http.netflix.loadbalancer.LoadBalancerBuilder;
import com.spotify.ffwd.http.netflix.loadbalancer.RetryRule;
import com.spotify.ffwd.http.netflix.loadbalancer.Server;
import com.spotify.ffwd.http.netflix.loadbalancer.ZoneAwareLoadBalancer;
import com.spotify.ffwd.http.netflix.loadbalancer.reactive.LoadBalancerCommand;
import com.spotify.ffwd.http.netflix.loadbalancer.reactive.ServerOperation;
import com.spotify.ffwd.http.okhttp3.OkHttpClient;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Func1;

public class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private final RawHttpClientFactory clientFactory;
    private final ILoadBalancer loadBalancer;
    private final int retries;
    private final long baseDelayMillis;
    private final long maxDelayMillis;

    public Observable<Void> sendBatch(final Batch batch) {
        return this.buildCommand().submit(new ServerOperation<Void>(){

            @Override
            public Observable<Void> call(Server server) {
                return HttpClient.this.clientFactory.newClient(server).sendBatch(batch);
            }
        }).retryWhen((Func1)new RetryWithDelay(this.retries, this.baseDelayMillis, this.maxDelayMillis));
    }

    protected LoadBalancerCommand<Void> buildCommand() {
        return LoadBalancerCommand.builder().withLoadBalancer(this.loadBalancer).build();
    }

    @ConstructorProperties(value={"clientFactory", "loadBalancer", "retries", "baseDelayMillis", "maxDelayMillis"})
    public HttpClient(RawHttpClientFactory clientFactory, ILoadBalancer loadBalancer, int retries, long baseDelayMillis, long maxDelayMillis) {
        this.clientFactory = clientFactory;
        this.loadBalancer = loadBalancer;
        this.retries = retries;
        this.baseDelayMillis = baseDelayMillis;
        this.maxDelayMillis = maxDelayMillis;
    }

    public RawHttpClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public ILoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public int getRetries() {
        return this.retries;
    }

    public long getBaseDelayMillis() {
        return this.baseDelayMillis;
    }

    public long getMaxDelayMillis() {
        return this.maxDelayMillis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClient)) {
            return false;
        }
        HttpClient other = (HttpClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RawHttpClientFactory this$clientFactory = this.getClientFactory();
        RawHttpClientFactory other$clientFactory = other.getClientFactory();
        if (this$clientFactory == null ? other$clientFactory != null : !((Object)this$clientFactory).equals(other$clientFactory)) {
            return false;
        }
        ILoadBalancer this$loadBalancer = this.getLoadBalancer();
        ILoadBalancer other$loadBalancer = other.getLoadBalancer();
        if (this$loadBalancer == null ? other$loadBalancer != null : !this$loadBalancer.equals(other$loadBalancer)) {
            return false;
        }
        if (this.getRetries() != other.getRetries()) {
            return false;
        }
        if (this.getBaseDelayMillis() != other.getBaseDelayMillis()) {
            return false;
        }
        return this.getMaxDelayMillis() == other.getMaxDelayMillis();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RawHttpClientFactory $clientFactory = this.getClientFactory();
        result = result * 59 + ($clientFactory == null ? 43 : ((Object)$clientFactory).hashCode());
        ILoadBalancer $loadBalancer = this.getLoadBalancer();
        result = result * 59 + ($loadBalancer == null ? 43 : $loadBalancer.hashCode());
        result = result * 59 + this.getRetries();
        long $baseDelayMillis = this.getBaseDelayMillis();
        result = result * 59 + (int)($baseDelayMillis >>> 32 ^ $baseDelayMillis);
        long $maxDelayMillis = this.getMaxDelayMillis();
        result = result * 59 + (int)($maxDelayMillis >>> 32 ^ $maxDelayMillis);
        return result;
    }

    public String toString() {
        return "HttpClient(clientFactory=" + this.getClientFactory() + ", loadBalancer=" + this.getLoadBalancer() + ", retries=" + this.getRetries() + ", baseDelayMillis=" + this.getBaseDelayMillis() + ", maxDelayMillis=" + this.getMaxDelayMillis() + ")";
    }

    public static class Builder {
        public static final int DEFAULT_RETRIES = 3;
        public static final long DEFAULT_BASE_DELAY_MILLIS = 50L;
        public static final long DEFAULT_MAX_DELAY_MILLIS = 10000L;
        private HttpDiscovery discovery;
        private String searchDomain;
        private Integer retries;
        private Long baseDelayMillis;
        private Long maxDelayMillis;

        public static ObjectMapper setupApplicationJson() {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule(new Jdk8Module());
            mapper.enable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES);
            mapper.enable(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES);
            return mapper;
        }

        public HttpClient build() {
            HttpDiscovery discovery = this.discovery == null ? HttpDiscovery.Static.supplyDefault() : this.discovery;
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.addInterceptor(new GzipRequestInterceptor());
            ObjectMapper objectMapper = Builder.setupApplicationJson();
            RawHttpClientFactory httpClientFactory = new RawHttpClientFactory(objectMapper, builder.build());
            HttpPing httpPing = new HttpPing(httpClientFactory);
            ZoneAwareLoadBalancer<Server> loadBalancer = discovery.apply(LoadBalancerBuilder.newBuilder(), this.searchDomain).withPing(httpPing).withRule(new RetryRule(new AvailabilityFilteringRule())).buildDynamicServerListLoadBalancer();
            int retries = this.retries == null ? 3 : this.retries;
            long baseDelayMillis = this.baseDelayMillis == null ? 50L : this.baseDelayMillis;
            long maxDelayMillis = this.maxDelayMillis == null ? 10000L : this.maxDelayMillis;
            return new HttpClient(httpClientFactory, loadBalancer, retries, baseDelayMillis, maxDelayMillis);
        }

        public Builder discovery(HttpDiscovery discovery) {
            this.discovery = discovery;
            return this;
        }

        public Builder searchDomain(String searchDomain) {
            this.searchDomain = searchDomain;
            return this;
        }

        public Builder retries(int retries) {
            this.retries = retries;
            return this;
        }

        public Builder baseDelayMillis(long baseDelayMillis) {
            this.baseDelayMillis = baseDelayMillis;
            return this;
        }

        public Builder maxDelayMillis(long maxDelayMillis) {
            this.maxDelayMillis = maxDelayMillis;
            return this;
        }
    }
}

