/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http;

import com.spotify.ffwd.http.SrvServerList;
import com.spotify.ffwd.http.StaticServerList;
import com.spotify.ffwd.http.fasterxml.jackson.annotation.JsonCreator;
import com.spotify.ffwd.http.fasterxml.jackson.annotation.JsonSubTypes;
import com.spotify.ffwd.http.fasterxml.jackson.annotation.JsonTypeInfo;
import com.spotify.ffwd.http.fasterxml.jackson.annotation.JsonTypeName;
import com.spotify.ffwd.http.netflix.loadbalancer.LoadBalancerBuilder;
import com.spotify.ffwd.http.netflix.loadbalancer.Server;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Static.class), @JsonSubTypes.Type(value=Srv.class)})
public interface HttpDiscovery {
    public static final HostAndPort DEFAULT_SERVER = new HostAndPort("localhost", 8080);

    public LoadBalancerBuilder<Server> apply(LoadBalancerBuilder<Server> var1, String var2);

    public static class HostAndPort {
        private final String host;
        private final int port;

        @JsonCreator
        public static HostAndPort create(String input) {
            String[] parts = input.split(":");
            if (parts.length != 2) {
                throw new RuntimeException("Not a valid server (expected host:port): " + input);
            }
            String host = parts[0];
            int port = Integer.parseInt(parts[1]);
            return new HostAndPort(host, port);
        }

        public HostAndPort withOptionalSearchDomain(String searchDomain) {
            if (this.host.equals("localhost") || this.host.endsWith(".")) {
                return this;
            }
            if (searchDomain == null) {
                return this;
            }
            return new HostAndPort(this.host + "." + searchDomain, this.port);
        }

        @ConstructorProperties(value={"host", "port"})
        public HostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HostAndPort)) {
                return false;
            }
            HostAndPort other = (HostAndPort)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            return this.getPort() == other.getPort();
        }

        protected boolean canEqual(Object other) {
            return other instanceof HostAndPort;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            result = result * 59 + this.getPort();
            return result;
        }

        public String toString() {
            return "HttpDiscovery.HostAndPort(host=" + this.getHost() + ", port=" + this.getPort() + ")";
        }
    }

    @JsonTypeName(value="srv")
    public static class Srv
    implements HttpDiscovery {
        private final String record;

        @Override
        public LoadBalancerBuilder<Server> apply(LoadBalancerBuilder<Server> builder, String searchDomain) {
            SrvServerList list = searchDomain != null ? new SrvServerList(this.record + "." + searchDomain) : new SrvServerList(this.record);
            return builder.withDynamicServerList(list);
        }

        @ConstructorProperties(value={"record"})
        public Srv(String record) {
            this.record = record;
        }

        public String getRecord() {
            return this.record;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Srv)) {
                return false;
            }
            Srv other = (Srv)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$record = this.getRecord();
            String other$record = other.getRecord();
            return !(this$record == null ? other$record != null : !this$record.equals(other$record));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Srv;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $record = this.getRecord();
            result = result * 59 + ($record == null ? 43 : $record.hashCode());
            return result;
        }

        public String toString() {
            return "HttpDiscovery.Srv(record=" + this.getRecord() + ")";
        }
    }

    @JsonTypeName(value="static")
    public static class Static
    implements HttpDiscovery {
        private final List<HostAndPort> servers;

        @Override
        public LoadBalancerBuilder<Server> apply(LoadBalancerBuilder<Server> builder, String searchDomain) {
            ArrayList<Server> out = new ArrayList<Server>();
            for (HostAndPort hostAndPort : this.servers) {
                HostAndPort modified = hostAndPort.withOptionalSearchDomain(searchDomain);
                out.add(new Server(modified.getHost(), modified.getPort()));
            }
            return builder.withDynamicServerList(new StaticServerList(out));
        }

        static HttpDiscovery supplyDefault() {
            return new Static(Collections.singletonList(DEFAULT_SERVER));
        }

        @ConstructorProperties(value={"servers"})
        public Static(List<HostAndPort> servers) {
            this.servers = servers;
        }

        public List<HostAndPort> getServers() {
            return this.servers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Static)) {
                return false;
            }
            Static other = (Static)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<HostAndPort> this$servers = this.getServers();
            List<HostAndPort> other$servers = other.getServers();
            return !(this$servers == null ? other$servers != null : !((Object)this$servers).equals(other$servers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Static;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<HostAndPort> $servers = this.getServers();
            result = result * 59 + ($servers == null ? 43 : ((Object)$servers).hashCode());
            return result;
        }

        public String toString() {
            return "HttpDiscovery.Static(servers=" + this.getServers() + ")";
        }
    }
}

