/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http;

import com.spotify.ffwd.http.RawHttpClientFactory;
import com.spotify.ffwd.http.netflix.loadbalancer.IPing;
import com.spotify.ffwd.http.netflix.loadbalancer.Server;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPing
implements IPing {
    private static final Logger log = LoggerFactory.getLogger(HttpPing.class);
    private final RawHttpClientFactory clientFactory;

    @Override
    public boolean isAlive(Server server) {
        try {
            this.clientFactory.newClient(server).ping().toCompletable().await();
        }
        catch (Exception e) {
            log.warn("Error when pinging server ({}): {}", (Object)server, (Object)e.getMessage());
            log.trace("Error when pinging server ({}): {}", new Object[]{server, e.getMessage(), e});
            return false;
        }
        return true;
    }

    @ConstructorProperties(value={"clientFactory"})
    public HttpPing(RawHttpClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public RawHttpClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpPing)) {
            return false;
        }
        HttpPing other = (HttpPing)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RawHttpClientFactory this$clientFactory = this.getClientFactory();
        RawHttpClientFactory other$clientFactory = other.getClientFactory();
        return !(this$clientFactory == null ? other$clientFactory != null : !((Object)this$clientFactory).equals(other$clientFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpPing;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RawHttpClientFactory $clientFactory = this.getClientFactory();
        result = result * 59 + ($clientFactory == null ? 43 : ((Object)$clientFactory).hashCode());
        return result;
    }

    public String toString() {
        return "HttpPing(clientFactory=" + this.getClientFactory() + ")";
    }
}

