/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http;

import com.spotify.ffwd.http.Batch;
import com.spotify.ffwd.http.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.ffwd.http.fasterxml.jackson.databind.ObjectMapper;
import com.spotify.ffwd.http.okhttp3.Call;
import com.spotify.ffwd.http.okhttp3.Callback;
import com.spotify.ffwd.http.okhttp3.MediaType;
import com.spotify.ffwd.http.okhttp3.OkHttpClient;
import com.spotify.ffwd.http.okhttp3.Request;
import com.spotify.ffwd.http.okhttp3.RequestBody;
import com.spotify.ffwd.http.okhttp3.Response;
import java.beans.ConstructorProperties;
import java.io.IOException;
import rx.Observable;
import rx.Subscriber;

public class RawHttpClient {
    public static final String V1_BATCH_ENDPOINT = "v1/batch";
    public static final String PING_ENDPOINT = "ping";
    private final ObjectMapper mapper;
    private final OkHttpClient httpClient;
    private final String baseUrl;

    public Observable<Void> sendBatch(Batch batch) {
        byte[] body;
        try {
            body = this.mapper.writeValueAsBytes(batch);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        Request.Builder request = new Request.Builder();
        request.url(this.baseUrl + "/" + V1_BATCH_ENDPOINT);
        request.post(RequestBody.create(MediaType.parse("application/json"), body));
        return this.execute(request);
    }

    public Observable<Void> ping() {
        Request.Builder request = new Request.Builder();
        request.url(this.baseUrl + "/" + PING_ENDPOINT);
        request.get();
        return this.execute(request);
    }

    private Observable<Void> execute(final Request.Builder request) {
        return Observable.unsafeCreate((Observable.OnSubscribe)new Observable.OnSubscribe<Void>(){

            public void call(final Subscriber<? super Void> subscriber) {
                Call call = RawHttpClient.this.httpClient.newCall(request.build());
                call.enqueue(new Callback(){

                    @Override
                    public void onFailure(Call call, IOException e) {
                        subscriber.onError((Throwable)e);
                    }

                    @Override
                    public void onResponse(Call call, Response response) throws IOException {
                        if (response.isSuccessful()) {
                            subscriber.onCompleted();
                        } else {
                            subscriber.onError((Throwable)new RuntimeException("HTTP request failed: " + response.code() + ": " + response.message()));
                        }
                        response.close();
                    }
                });
            }
        });
    }

    @ConstructorProperties(value={"mapper", "httpClient", "baseUrl"})
    public RawHttpClient(ObjectMapper mapper, OkHttpClient httpClient, String baseUrl) {
        this.mapper = mapper;
        this.httpClient = httpClient;
        this.baseUrl = baseUrl;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawHttpClient)) {
            return false;
        }
        RawHttpClient other = (RawHttpClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMapper this$mapper = this.getMapper();
        ObjectMapper other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        OkHttpClient this$httpClient = this.getHttpClient();
        OkHttpClient other$httpClient = other.getHttpClient();
        if (this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        return !(this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawHttpClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        OkHttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        return result;
    }

    public String toString() {
        return "RawHttpClient(mapper=" + this.getMapper() + ", httpClient=" + this.getHttpClient() + ", baseUrl=" + this.getBaseUrl() + ")";
    }
}

