/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http;

import com.spotify.ffwd.http.RawHttpClient;
import com.spotify.ffwd.http.fasterxml.jackson.databind.ObjectMapper;
import com.spotify.ffwd.http.netflix.loadbalancer.Server;
import com.spotify.ffwd.http.okhttp3.OkHttpClient;
import java.beans.ConstructorProperties;

public class RawHttpClientFactory {
    private final ObjectMapper mapper;
    private final OkHttpClient httpClient;

    public RawHttpClient newClient(Server server) {
        String baseUrl = "http://" + server.getHost() + ":" + server.getPort();
        return new RawHttpClient(this.mapper, this.httpClient, baseUrl);
    }

    @ConstructorProperties(value={"mapper", "httpClient"})
    public RawHttpClientFactory(ObjectMapper mapper, OkHttpClient httpClient) {
        this.mapper = mapper;
        this.httpClient = httpClient;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawHttpClientFactory)) {
            return false;
        }
        RawHttpClientFactory other = (RawHttpClientFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMapper this$mapper = this.getMapper();
        ObjectMapper other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        OkHttpClient this$httpClient = this.getHttpClient();
        OkHttpClient other$httpClient = other.getHttpClient();
        return !(this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawHttpClientFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        OkHttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        return result;
    }

    public String toString() {
        return "RawHttpClientFactory(mapper=" + this.getMapper() + ", httpClient=" + this.getHttpClient() + ")";
    }
}

