/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

public class RetryWithDelay
implements Func1<Observable<? extends Throwable>, Observable<?>> {
    private final int maxRetries;
    private long retryDelayMillis;
    private final long maxDelayMillis;
    private int retryCount;
    private final Random random = new Random();

    public RetryWithDelay(int maxRetries, long retryDelayMillis, long maxDelayMillis) {
        this.maxRetries = maxRetries;
        this.retryDelayMillis = retryDelayMillis;
        this.maxDelayMillis = maxDelayMillis;
        this.retryCount = 0;
    }

    public Observable<?> call(Observable<? extends Throwable> attempts) {
        return attempts.flatMap(new Func1<Throwable, Observable<?>>(){

            public Observable<?> call(Throwable throwable) {
                if (++RetryWithDelay.this.retryCount < RetryWithDelay.this.maxRetries) {
                    long retryMillis = RetryWithDelay.this.retryDelayMillis;
                    long jitter = (long)(RetryWithDelay.this.random.nextFloat() * (float)retryMillis);
                    RetryWithDelay.this.retryDelayMillis = Math.min(RetryWithDelay.this.retryDelayMillis * 2L, RetryWithDelay.this.maxDelayMillis);
                    return Observable.timer((long)(retryMillis + jitter), (TimeUnit)TimeUnit.MILLISECONDS);
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }
}

