/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http;

import com.spotify.ffwd.http.netflix.loadbalancer.Server;
import com.spotify.ffwd.http.netflix.loadbalancer.ServerList;
import com.spotify.ffwd.http.xbill.DNS.Lookup;
import com.spotify.ffwd.http.xbill.DNS.Record;
import com.spotify.ffwd.http.xbill.DNS.SRVRecord;
import com.spotify.ffwd.http.xbill.DNS.TextParseException;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrvServerList
implements ServerList<Server> {
    private static final Logger log = LoggerFactory.getLogger(SrvServerList.class);
    private final String record;

    @Override
    public List<Server> getInitialListOfServers() {
        return this.lookup();
    }

    @Override
    public List<Server> getUpdatedListOfServers() {
        return this.lookup();
    }

    private List<Server> lookup() {
        Lookup lookup;
        try {
            lookup = new Lookup(this.record, 33, 1);
        }
        catch (TextParseException e) {
            throw new RuntimeException(e);
        }
        Record[] result = lookup.run();
        if (lookup.getResult() != 0) {
            throw new RuntimeException("DNS lookup failed: " + lookup.getErrorString() + ": " + this.record);
        }
        ArrayList<Server> results = new ArrayList<Server>();
        if (result != null) {
            for (Record a : result) {
                SRVRecord srv = (SRVRecord)a;
                results.add(new Server(srv.getTarget().canonicalize().toString(), srv.getPort()));
            }
        }
        return Collections.unmodifiableList(results);
    }

    @ConstructorProperties(value={"record"})
    public SrvServerList(String record) {
        this.record = record;
    }

    public String getRecord() {
        return this.record;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SrvServerList)) {
            return false;
        }
        SrvServerList other = (SrvServerList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$record = this.getRecord();
        String other$record = other.getRecord();
        return !(this$record == null ? other$record != null : !this$record.equals(other$record));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SrvServerList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $record = this.getRecord();
        result = result * 59 + ($record == null ? 43 : $record.hashCode());
        return result;
    }

    public String toString() {
        return "SrvServerList(record=" + this.getRecord() + ")";
    }
}

