/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.commons.configuration;

import com.spotify.ffwd.http.commons.configuration.AbstractFileConfiguration;
import com.spotify.ffwd.http.commons.configuration.ConfigurationException;
import com.spotify.ffwd.http.commons.configuration.FileConfiguration;
import com.spotify.ffwd.http.commons.configuration.FileSystem;
import com.spotify.ffwd.http.commons.configuration.FileSystemBased;
import com.spotify.ffwd.http.commons.configuration.HierarchicalConfiguration;
import com.spotify.ffwd.http.commons.configuration.event.ConfigurationErrorEvent;
import com.spotify.ffwd.http.commons.configuration.event.ConfigurationErrorListener;
import com.spotify.ffwd.http.commons.configuration.event.ConfigurationEvent;
import com.spotify.ffwd.http.commons.configuration.event.ConfigurationListener;
import com.spotify.ffwd.http.commons.configuration.reloading.Reloadable;
import com.spotify.ffwd.http.commons.configuration.reloading.ReloadingStrategy;
import com.spotify.ffwd.http.commons.configuration.tree.ConfigurationNode;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHierarchicalFileConfiguration
extends HierarchicalConfiguration
implements FileConfiguration,
ConfigurationListener,
ConfigurationErrorListener,
FileSystemBased,
Reloadable {
    private FileConfigurationDelegate delegate;

    protected AbstractHierarchicalFileConfiguration() {
        this.initialize();
    }

    protected AbstractHierarchicalFileConfiguration(HierarchicalConfiguration c) {
        super(c);
        this.initialize();
    }

    public AbstractHierarchicalFileConfiguration(String fileName) throws ConfigurationException {
        this();
        this.delegate.setFileName(fileName);
        this.load();
    }

    public AbstractHierarchicalFileConfiguration(File file) throws ConfigurationException {
        this();
        this.setFile(file);
        if (file.exists()) {
            this.load();
        }
    }

    public AbstractHierarchicalFileConfiguration(URL url) throws ConfigurationException {
        this();
        this.setURL(url);
        this.load();
    }

    private void initialize() {
        this.delegate = this.createDelegate();
        this.initDelegate(this.delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPropertyDirect(String key, Object obj) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            super.addPropertyDirect(key, obj);
            this.delegate.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearProperty(String key) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            super.clearProperty(key);
            this.delegate.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTree(String key) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            super.clearTree(key);
            this.delegate.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String key, Object value) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            super.setProperty(key, value);
            this.delegate.possiblySave();
        }
    }

    @Override
    public void load() throws ConfigurationException {
        this.delegate.load();
    }

    @Override
    public void load(String fileName) throws ConfigurationException {
        this.delegate.load(fileName);
    }

    @Override
    public void load(File file) throws ConfigurationException {
        this.delegate.load(file);
    }

    @Override
    public void load(URL url) throws ConfigurationException {
        this.delegate.load(url);
    }

    @Override
    public void load(InputStream in) throws ConfigurationException {
        this.delegate.load(in);
    }

    @Override
    public void load(InputStream in, String encoding) throws ConfigurationException {
        this.delegate.load(in, encoding);
    }

    @Override
    public void save() throws ConfigurationException {
        this.delegate.save();
    }

    @Override
    public void save(String fileName) throws ConfigurationException {
        this.delegate.save(fileName);
    }

    @Override
    public void save(File file) throws ConfigurationException {
        this.delegate.save(file);
    }

    @Override
    public void save(URL url) throws ConfigurationException {
        this.delegate.save(url);
    }

    @Override
    public void save(OutputStream out) throws ConfigurationException {
        this.delegate.save(out);
    }

    @Override
    public void save(OutputStream out, String encoding) throws ConfigurationException {
        this.delegate.save(out, encoding);
    }

    @Override
    public String getFileName() {
        return this.delegate.getFileName();
    }

    @Override
    public void setFileName(String fileName) {
        this.delegate.setFileName(fileName);
    }

    @Override
    public String getBasePath() {
        return this.delegate.getBasePath();
    }

    @Override
    public void setBasePath(String basePath) {
        this.delegate.setBasePath(basePath);
    }

    @Override
    public File getFile() {
        return this.delegate.getFile();
    }

    @Override
    public void setFile(File file) {
        this.delegate.setFile(file);
    }

    @Override
    public URL getURL() {
        return this.delegate.getURL();
    }

    @Override
    public void setURL(URL url) {
        this.delegate.setURL(url);
    }

    @Override
    public void setAutoSave(boolean autoSave) {
        this.delegate.setAutoSave(autoSave);
    }

    @Override
    public boolean isAutoSave() {
        return this.delegate.isAutoSave();
    }

    @Override
    public ReloadingStrategy getReloadingStrategy() {
        return this.delegate.getReloadingStrategy();
    }

    @Override
    public void setReloadingStrategy(ReloadingStrategy strategy) {
        this.delegate.setReloadingStrategy(strategy);
    }

    @Override
    public void reload() {
        this.reload(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reload(boolean checkReload) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            boolean bl;
            this.setDetailEvents(false);
            try {
                bl = this.delegate.reload(checkReload);
            }
            catch (Throwable throwable) {
                this.setDetailEvents(true);
                throw throwable;
            }
            this.setDetailEvents(true);
            return bl;
        }
    }

    public void refresh() throws ConfigurationException {
        this.delegate.refresh();
    }

    @Override
    public String getEncoding() {
        return this.delegate.getEncoding();
    }

    @Override
    public void setEncoding(String encoding) {
        this.delegate.setEncoding(encoding);
    }

    @Override
    public Object getReloadLock() {
        return this.delegate.getReloadLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String key) {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getKeys() {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.getKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getKeys(String prefix) {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.getKeys(prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String key) {
        if (this.reload(true)) {
            Object object = this.delegate.getReloadLock();
            synchronized (object) {
                return super.getProperty(key);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNodes(String key, Collection<? extends ConfigurationNode> nodes) {
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            super.addNodes(key, nodes);
            this.delegate.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<ConfigurationNode> fetchNodeList(String key) {
        this.reload();
        Object object = this.delegate.getReloadLock();
        synchronized (object) {
            return super.fetchNodeList(key);
        }
    }

    @Override
    protected void subnodeConfigurationChanged(ConfigurationEvent event) {
        this.delegate.possiblySave();
        super.subnodeConfigurationChanged(event);
    }

    protected FileConfigurationDelegate createDelegate() {
        return new FileConfigurationDelegate();
    }

    private void initDelegate(FileConfigurationDelegate del) {
        del.addConfigurationListener(this);
        del.addErrorListener(this);
        del.setLogger(this.getLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationChanged(ConfigurationEvent event) {
        this.setDetailEvents(true);
        try {
            this.fireEvent(event.getType(), event.getPropertyName(), event.getPropertyValue(), event.isBeforeUpdate());
        }
        finally {
            this.setDetailEvents(false);
        }
    }

    @Override
    public void configurationError(ConfigurationErrorEvent event) {
        this.fireError(event.getType(), event.getPropertyName(), event.getPropertyValue(), event.getCause());
    }

    protected FileConfigurationDelegate getDelegate() {
        return this.delegate;
    }

    protected void setDelegate(FileConfigurationDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setFileSystem(FileSystem fileSystem) {
        this.delegate.setFileSystem(fileSystem);
    }

    @Override
    public void resetFileSystem() {
        this.delegate.resetFileSystem();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.delegate.getFileSystem();
    }

    protected class FileConfigurationDelegate
    extends AbstractFileConfiguration {
        protected FileConfigurationDelegate() {
        }

        public void load(Reader in) throws ConfigurationException {
            AbstractHierarchicalFileConfiguration.this.load(in);
        }

        public void save(Writer out) throws ConfigurationException {
            AbstractHierarchicalFileConfiguration.this.save(out);
        }

        public void clear() {
            AbstractHierarchicalFileConfiguration.this.clear();
        }
    }
}

