/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.commons.configuration;

import com.spotify.ffwd.http.commons.configuration.AbstractHierarchicalFileConfiguration;
import com.spotify.ffwd.http.commons.configuration.Configuration;
import com.spotify.ffwd.http.commons.configuration.ConfigurationException;
import com.spotify.ffwd.http.commons.configuration.HierarchicalConfiguration;
import com.spotify.ffwd.http.commons.configuration.SubnodeConfiguration;
import com.spotify.ffwd.http.commons.configuration.event.ConfigurationErrorListener;
import com.spotify.ffwd.http.commons.configuration.event.ConfigurationListener;
import com.spotify.ffwd.http.commons.configuration.tree.ConfigurationNode;
import com.spotify.ffwd.http.commons.configuration.tree.ExpressionEngine;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternSubtreeConfigurationWrapper
extends AbstractHierarchicalFileConfiguration {
    private static ThreadLocal<Boolean> recursive = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final AbstractHierarchicalFileConfiguration config;
    private final String path;
    private final boolean trailing;
    private boolean init;

    public PatternSubtreeConfigurationWrapper(AbstractHierarchicalFileConfiguration config, String path) {
        this.config = config;
        this.path = path;
        this.trailing = path.endsWith("/");
        this.init = true;
    }

    @Override
    public Object getReloadLock() {
        return this.config.getReloadLock();
    }

    @Override
    public void addProperty(String key, Object value) {
        this.config.addProperty(this.makePath(key), value);
    }

    @Override
    public void clear() {
        this.getConfig().clear();
    }

    @Override
    public void clearProperty(String key) {
        this.config.clearProperty(this.makePath(key));
    }

    @Override
    public boolean containsKey(String key) {
        return this.config.containsKey(this.makePath(key));
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.config.getBigDecimal(this.makePath(key), defaultValue);
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return this.config.getBigDecimal(this.makePath(key));
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.config.getBigInteger(this.makePath(key), defaultValue);
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return this.config.getBigInteger(this.makePath(key));
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.config.getBoolean(this.makePath(key), defaultValue);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.config.getBoolean(this.makePath(key), defaultValue);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.config.getBoolean(this.makePath(key));
    }

    @Override
    public byte getByte(String key, byte defaultValue) {
        return this.config.getByte(this.makePath(key), defaultValue);
    }

    @Override
    public Byte getByte(String key, Byte defaultValue) {
        return this.config.getByte(this.makePath(key), defaultValue);
    }

    @Override
    public byte getByte(String key) {
        return this.config.getByte(this.makePath(key));
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.config.getDouble(this.makePath(key), defaultValue);
    }

    @Override
    public Double getDouble(String key, Double defaultValue) {
        return this.config.getDouble(this.makePath(key), defaultValue);
    }

    @Override
    public double getDouble(String key) {
        return this.config.getDouble(this.makePath(key));
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return this.config.getFloat(this.makePath(key), defaultValue);
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        return this.config.getFloat(this.makePath(key), defaultValue);
    }

    @Override
    public float getFloat(String key) {
        return this.config.getFloat(this.makePath(key));
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.config.getInt(this.makePath(key), defaultValue);
    }

    @Override
    public int getInt(String key) {
        return this.config.getInt(this.makePath(key));
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        return this.config.getInteger(this.makePath(key), defaultValue);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.config.getKeys(this.makePath());
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        return this.config.getKeys(this.makePath(prefix));
    }

    @Override
    public List<Object> getList(String key, List<Object> defaultValue) {
        return this.config.getList(this.makePath(key), defaultValue);
    }

    @Override
    public List<Object> getList(String key) {
        return this.config.getList(this.makePath(key));
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.config.getLong(this.makePath(key), defaultValue);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        return this.config.getLong(this.makePath(key), defaultValue);
    }

    @Override
    public long getLong(String key) {
        return this.config.getLong(this.makePath(key));
    }

    @Override
    public Properties getProperties(String key) {
        return this.config.getProperties(this.makePath(key));
    }

    @Override
    public Object getProperty(String key) {
        return this.config.getProperty(this.makePath(key));
    }

    @Override
    public short getShort(String key, short defaultValue) {
        return this.config.getShort(this.makePath(key), defaultValue);
    }

    @Override
    public Short getShort(String key, Short defaultValue) {
        return this.config.getShort(this.makePath(key), defaultValue);
    }

    @Override
    public short getShort(String key) {
        return this.config.getShort(this.makePath(key));
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.config.getString(this.makePath(key), defaultValue);
    }

    @Override
    public String getString(String key) {
        return this.config.getString(this.makePath(key));
    }

    @Override
    public String[] getStringArray(String key) {
        return this.config.getStringArray(this.makePath(key));
    }

    @Override
    public boolean isEmpty() {
        return this.getConfig().isEmpty();
    }

    @Override
    public void setProperty(String key, Object value) {
        this.getConfig().setProperty(key, value);
    }

    @Override
    public Configuration subset(String prefix) {
        return this.getConfig().subset(prefix);
    }

    @Override
    public HierarchicalConfiguration.Node getRoot() {
        return this.getConfig().getRoot();
    }

    @Override
    public void setRoot(HierarchicalConfiguration.Node node) {
        if (this.init) {
            this.getConfig().setRoot(node);
        } else {
            super.setRoot(node);
        }
    }

    @Override
    public ConfigurationNode getRootNode() {
        return this.getConfig().getRootNode();
    }

    @Override
    public void setRootNode(ConfigurationNode rootNode) {
        if (this.init) {
            this.getConfig().setRootNode(rootNode);
        } else {
            super.setRootNode(rootNode);
        }
    }

    @Override
    public ExpressionEngine getExpressionEngine() {
        return this.config.getExpressionEngine();
    }

    @Override
    public void setExpressionEngine(ExpressionEngine expressionEngine) {
        if (this.init) {
            this.config.setExpressionEngine(expressionEngine);
        } else {
            super.setExpressionEngine(expressionEngine);
        }
    }

    @Override
    public void addNodes(String key, Collection<? extends ConfigurationNode> nodes) {
        this.getConfig().addNodes(key, nodes);
    }

    @Override
    public SubnodeConfiguration configurationAt(String key, boolean supportUpdates) {
        return this.config.configurationAt(this.makePath(key), supportUpdates);
    }

    @Override
    public SubnodeConfiguration configurationAt(String key) {
        return this.config.configurationAt(this.makePath(key));
    }

    @Override
    public List<HierarchicalConfiguration> configurationsAt(String key) {
        return this.config.configurationsAt(this.makePath(key));
    }

    @Override
    public void clearTree(String key) {
        this.config.clearTree(this.makePath(key));
    }

    @Override
    public int getMaxIndex(String key) {
        return this.config.getMaxIndex(this.makePath(key));
    }

    @Override
    public Configuration interpolatedConfiguration() {
        return this.getConfig().interpolatedConfiguration();
    }

    @Override
    public void addConfigurationListener(ConfigurationListener l) {
        this.getConfig().addConfigurationListener(l);
    }

    @Override
    public boolean removeConfigurationListener(ConfigurationListener l) {
        return this.getConfig().removeConfigurationListener(l);
    }

    @Override
    public Collection<ConfigurationListener> getConfigurationListeners() {
        return this.getConfig().getConfigurationListeners();
    }

    @Override
    public void clearConfigurationListeners() {
        this.getConfig().clearConfigurationListeners();
    }

    @Override
    public void addErrorListener(ConfigurationErrorListener l) {
        this.getConfig().addErrorListener(l);
    }

    @Override
    public boolean removeErrorListener(ConfigurationErrorListener l) {
        return this.getConfig().removeErrorListener(l);
    }

    @Override
    public void clearErrorListeners() {
        this.getConfig().clearErrorListeners();
    }

    @Override
    public void save(Writer writer) throws ConfigurationException {
        this.config.save(writer);
    }

    @Override
    public void load(Reader reader) throws ConfigurationException {
        this.config.load(reader);
    }

    @Override
    public Collection<ConfigurationErrorListener> getErrorListeners() {
        return this.getConfig().getErrorListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object resolveContainerStore(String key) {
        if (recursive.get().booleanValue()) {
            return null;
        }
        recursive.set(Boolean.TRUE);
        try {
            Object object = super.resolveContainerStore(key);
            return object;
        }
        finally {
            recursive.set(Boolean.FALSE);
        }
    }

    private HierarchicalConfiguration getConfig() {
        return this.config.configurationAt(this.makePath());
    }

    private String makePath() {
        String pathPattern = this.trailing ? this.path.substring(0, this.path.length() - 1) : this.path;
        return this.getSubstitutor().replace(pathPattern);
    }

    private String makePath(String item) {
        String pathPattern = (item.length() == 0 || item.startsWith("/")) && this.trailing ? this.path.substring(0, this.path.length() - 1) : (!item.startsWith("/") || !this.trailing ? this.path + "/" : this.path);
        return this.getSubstitutor().replace(pathPattern) + item;
    }
}

