/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.commons.configuration.beanutils;

import com.spotify.ffwd.http.commons.beanutils.BeanUtils;
import com.spotify.ffwd.http.commons.beanutils.PropertyUtils;
import com.spotify.ffwd.http.commons.configuration.ConfigurationRuntimeException;
import com.spotify.ffwd.http.commons.configuration.beanutils.BeanDeclaration;
import com.spotify.ffwd.http.commons.configuration.beanutils.BeanFactory;
import com.spotify.ffwd.http.commons.configuration.beanutils.DefaultBeanFactory;
import com.spotify.ffwd.http.commons.lang.ClassUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanHelper {
    private static Map<String, BeanFactory> beanFactories = Collections.synchronizedMap(new HashMap());
    private static BeanFactory defaultBeanFactory = DefaultBeanFactory.INSTANCE;

    private BeanHelper() {
    }

    public static void registerBeanFactory(String name, BeanFactory factory) {
        if (name == null) {
            throw new IllegalArgumentException("Name for bean factory must not be null!");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Bean factory must not be null!");
        }
        beanFactories.put(name, factory);
    }

    public static BeanFactory deregisterBeanFactory(String name) {
        return beanFactories.remove(name);
    }

    public static Set<String> registeredFactoryNames() {
        return beanFactories.keySet();
    }

    public static BeanFactory getDefaultBeanFactory() {
        return defaultBeanFactory;
    }

    public static void setDefaultBeanFactory(BeanFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Default bean factory must not be null!");
        }
        defaultBeanFactory = factory;
    }

    public static void initBean(Object bean, BeanDeclaration data) throws ConfigurationRuntimeException {
        block4: {
            Map<String, Object> nestedBeans;
            block5: {
                BeanHelper.initBeanProperties(bean, data);
                nestedBeans = data.getNestedBeanDeclarations();
                if (nestedBeans == null) break block4;
                if (!(bean instanceof Collection)) break block5;
                Collection coll = (Collection)bean;
                if (nestedBeans.size() != 1) break block4;
                Map.Entry<String, Object> e = nestedBeans.entrySet().iterator().next();
                String propName = e.getKey();
                Class<?> defaultClass = BeanHelper.getDefaultClass(bean, propName);
                if (e.getValue() instanceof List) {
                    List decls = (List)e.getValue();
                    for (BeanDeclaration decl : decls) {
                        coll.add(BeanHelper.createBean(decl, defaultClass));
                    }
                } else {
                    BeanDeclaration decl = (BeanDeclaration)e.getValue();
                    coll.add(BeanHelper.createBean(decl, defaultClass));
                }
                break block4;
            }
            for (Map.Entry<String, Object> e : nestedBeans.entrySet()) {
                String propName = e.getKey();
                Class<?> defaultClass = BeanHelper.getDefaultClass(bean, propName);
                BeanHelper.initProperty(bean, propName, BeanHelper.createBean((BeanDeclaration)e.getValue(), defaultClass));
            }
        }
    }

    public static void initBeanProperties(Object bean, BeanDeclaration data) throws ConfigurationRuntimeException {
        Map<String, Object> properties = data.getBeanProperties();
        if (properties != null) {
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                String propName = e.getKey();
                BeanHelper.initProperty(bean, propName, e.getValue());
            }
        }
    }

    private static Class<?> getDefaultClass(Object bean, String propName) {
        try {
            PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor((Object)bean, (String)propName);
            if (desc == null) {
                return null;
            }
            return desc.getPropertyType();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void initProperty(Object bean, String propName, Object value) throws ConfigurationRuntimeException {
        if (!PropertyUtils.isWriteable((Object)bean, (String)propName)) {
            throw new ConfigurationRuntimeException("Property " + propName + " cannot be set on " + bean.getClass().getName());
        }
        try {
            BeanUtils.setProperty((Object)bean, (String)propName, (Object)value);
        }
        catch (IllegalAccessException iaex) {
            throw new ConfigurationRuntimeException(iaex);
        }
        catch (InvocationTargetException itex) {
            throw new ConfigurationRuntimeException(itex);
        }
    }

    public static void setProperty(Object bean, String propName, Object value) {
        if (PropertyUtils.isWriteable((Object)bean, (String)propName)) {
            BeanHelper.initProperty(bean, propName, value);
        }
    }

    public static Object createBean(BeanDeclaration data, Class<?> defaultClass, Object param) throws ConfigurationRuntimeException {
        if (data == null) {
            throw new IllegalArgumentException("Bean declaration must not be null!");
        }
        BeanFactory factory = BeanHelper.fetchBeanFactory(data);
        try {
            return factory.createBean(BeanHelper.fetchBeanClass(data, defaultClass, factory), data, param);
        }
        catch (Exception ex) {
            throw new ConfigurationRuntimeException(ex);
        }
    }

    public static Object createBean(BeanDeclaration data, Class<?> defaultClass) throws ConfigurationRuntimeException {
        return BeanHelper.createBean(data, defaultClass, null);
    }

    public static Object createBean(BeanDeclaration data) throws ConfigurationRuntimeException {
        return BeanHelper.createBean(data, null);
    }

    static Class<?> loadClass(String name, Class<?> callingClass) throws ClassNotFoundException {
        return ClassUtils.getClass(name);
    }

    private static Class<?> fetchBeanClass(BeanDeclaration data, Class<?> defaultClass, BeanFactory factory) throws ConfigurationRuntimeException {
        String clsName = data.getBeanClassName();
        if (clsName != null) {
            try {
                return BeanHelper.loadClass(clsName, factory.getClass());
            }
            catch (ClassNotFoundException cex) {
                throw new ConfigurationRuntimeException(cex);
            }
        }
        if (defaultClass != null) {
            return defaultClass;
        }
        Class<?> clazz = factory.getDefaultBeanClass();
        if (clazz == null) {
            throw new ConfigurationRuntimeException("Bean class is not specified!");
        }
        return clazz;
    }

    private static BeanFactory fetchBeanFactory(BeanDeclaration data) throws ConfigurationRuntimeException {
        String factoryName = data.getBeanFactoryName();
        if (factoryName != null) {
            BeanFactory factory = beanFactories.get(factoryName);
            if (factory == null) {
                throw new ConfigurationRuntimeException("Unknown bean factory: " + factoryName);
            }
            return factory;
        }
        return BeanHelper.getDefaultBeanFactory();
    }
}

