/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.commons.configuration.tree;

import com.spotify.ffwd.http.commons.configuration.tree.ConfigurationNode;
import com.spotify.ffwd.http.commons.configuration.tree.NodeCombiner;
import com.spotify.ffwd.http.commons.configuration.tree.ViewNode;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionCombiner
extends NodeCombiner {
    @Override
    public ConfigurationNode combine(ConfigurationNode node1, ConfigurationNode node2) {
        ViewNode result = this.createViewNode();
        result.setName(node1.getName());
        result.appendAttributes(node1);
        result.appendAttributes(node2);
        LinkedList<ConfigurationNode> children2 = new LinkedList<ConfigurationNode>(node2.getChildren());
        for (ConfigurationNode child1 : node1.getChildren()) {
            ConfigurationNode child2 = this.findCombineNode(node1, node2, child1, children2);
            if (child2 != null) {
                result.addChild(this.combine(child1, child2));
                children2.remove(child2);
                continue;
            }
            result.addChild(child1);
        }
        for (ConfigurationNode c : children2) {
            result.addChild(c);
        }
        return result;
    }

    protected ConfigurationNode findCombineNode(ConfigurationNode node1, ConfigurationNode node2, ConfigurationNode child, List<ConfigurationNode> children) {
        ConfigurationNode child2;
        if (child.getValue() == null && !this.isListNode(child) && node1.getChildrenCount(child.getName()) == 1 && node2.getChildrenCount(child.getName()) == 1 && (child2 = node2.getChildren(child.getName()).iterator().next()).getValue() == null) {
            return child2;
        }
        return null;
    }
}

