/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.fasterxml.jackson.databind;

import com.spotify.ffwd.http.fasterxml.jackson.core.JsonGenerator;
import com.spotify.ffwd.http.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.ffwd.http.fasterxml.jackson.databind.JavaType;
import com.spotify.ffwd.http.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.ffwd.http.fasterxml.jackson.databind.SerializerProvider;
import com.spotify.ffwd.http.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.spotify.ffwd.http.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.spotify.ffwd.http.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.spotify.ffwd.http.fasterxml.jackson.databind.ser.PropertyWriter;
import com.spotify.ffwd.http.fasterxml.jackson.databind.util.ClassUtil;
import com.spotify.ffwd.http.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.Iterator;

public abstract class JsonSerializer<T>
implements JsonFormatVisitable {
    public JsonSerializer<T> unwrappingSerializer(NameTransformer unwrapper) {
        return this;
    }

    public JsonSerializer<T> replaceDelegatee(JsonSerializer<?> delegatee) {
        throw new UnsupportedOperationException();
    }

    public JsonSerializer<?> withFilterId(Object filterId) {
        return this;
    }

    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonProcessingException;

    public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        Class<Object> clz = this.handledType();
        if (clz == null) {
            clz = value.getClass();
        }
        throw serializers.mappingException("Type id handling not implemented for type %s (by serializer of type %s)", clz.getName(), this.getClass().getName());
    }

    public Class<T> handledType() {
        return null;
    }

    @Deprecated
    public boolean isEmpty(T value) {
        return this.isEmpty(null, value);
    }

    public boolean isEmpty(SerializerProvider provider, T value) {
        return value == null;
    }

    public boolean usesObjectId() {
        return false;
    }

    public boolean isUnwrappingSerializer() {
        return false;
    }

    public JsonSerializer<?> getDelegatee() {
        return null;
    }

    public Iterator<PropertyWriter> properties() {
        return ClassUtil.emptyIterator();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType type) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectAnyFormat(type);
        }
    }

    public static abstract class None
    extends JsonSerializer<Object> {
    }
}

