/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.fasterxml.jackson.databind.ser.std;

import com.spotify.ffwd.http.fasterxml.jackson.annotation.JsonInclude;
import com.spotify.ffwd.http.fasterxml.jackson.core.JsonGenerator;
import com.spotify.ffwd.http.fasterxml.jackson.databind.AnnotationIntrospector;
import com.spotify.ffwd.http.fasterxml.jackson.databind.BeanProperty;
import com.spotify.ffwd.http.fasterxml.jackson.databind.JavaType;
import com.spotify.ffwd.http.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.ffwd.http.fasterxml.jackson.databind.JsonSerializer;
import com.spotify.ffwd.http.fasterxml.jackson.databind.MapperFeature;
import com.spotify.ffwd.http.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.spotify.ffwd.http.fasterxml.jackson.databind.SerializerProvider;
import com.spotify.ffwd.http.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.spotify.ffwd.http.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.spotify.ffwd.http.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.spotify.ffwd.http.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.spotify.ffwd.http.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.spotify.ffwd.http.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.spotify.ffwd.http.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.spotify.ffwd.http.fasterxml.jackson.databind.type.ReferenceType;
import com.spotify.ffwd.http.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;

public class AtomicReferenceSerializer
extends StdSerializer<AtomicReference<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _referredType;
    protected final BeanProperty _property;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final NameTransformer _unwrapper;
    protected final JsonInclude.Include _contentInclusion;
    protected transient PropertySerializerMap _dynamicSerializers;

    public AtomicReferenceSerializer(ReferenceType fullType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> ser) {
        super(fullType);
        this._referredType = fullType.getReferencedType();
        this._property = null;
        this._valueTypeSerializer = vts;
        this._valueSerializer = ser;
        this._unwrapper = null;
        this._contentInclusion = null;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected AtomicReferenceSerializer(AtomicReferenceSerializer base, BeanProperty property, TypeSerializer vts, JsonSerializer<?> valueSer, NameTransformer unwrapper, JsonInclude.Include contentIncl) {
        super(base);
        this._referredType = base._referredType;
        this._dynamicSerializers = base._dynamicSerializers;
        this._property = property;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSer;
        this._unwrapper = unwrapper;
        this._contentInclusion = contentIncl == JsonInclude.Include.USE_DEFAULTS || contentIncl == JsonInclude.Include.ALWAYS ? null : contentIncl;
    }

    @Override
    public JsonSerializer<AtomicReference<?>> unwrappingSerializer(NameTransformer transformer) {
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser != null) {
            ser = ser.unwrappingSerializer(transformer);
        }
        NameTransformer unwrapper = this._unwrapper == null ? transformer : NameTransformer.chainedTransformer(transformer, this._unwrapper);
        return this.withResolved(this._property, this._valueTypeSerializer, ser, unwrapper, this._contentInclusion);
    }

    protected AtomicReferenceSerializer withResolved(BeanProperty prop, TypeSerializer vts, JsonSerializer<?> valueSer, NameTransformer unwrapper, JsonInclude.Include contentIncl) {
        if (this._property == prop && contentIncl == this._contentInclusion && this._valueTypeSerializer == vts && this._valueSerializer == valueSer && this._unwrapper == unwrapper) {
            return this;
        }
        return new AtomicReferenceSerializer(this, prop, vts, valueSer, unwrapper, contentIncl);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonInclude.Value incl;
        JsonInclude.Include newIncl;
        JsonSerializer<Object> ser;
        TypeSerializer typeSer = this._valueTypeSerializer;
        if (typeSer != null) {
            typeSer = typeSer.forProperty(property);
        }
        if ((ser = this.findAnnotatedContentSerializer(provider, property)) == null) {
            ser = this._valueSerializer;
            if (ser == null) {
                if (this._useStatic(provider, property, this._referredType)) {
                    ser = this._findSerializer(provider, this._referredType, property);
                }
            } else {
                ser = provider.handlePrimaryContextualization(ser, property);
            }
        }
        JsonInclude.Include contentIncl = this._contentInclusion;
        if (property != null && (newIncl = (incl = property.findPropertyInclusion(provider.getConfig(), AtomicReference.class)).getContentInclusion()) != contentIncl && newIncl != JsonInclude.Include.USE_DEFAULTS) {
            contentIncl = newIncl;
        }
        return this.withResolved(property, typeSer, ser, this._unwrapper, contentIncl);
    }

    protected boolean _useStatic(SerializerProvider provider, BeanProperty property, JavaType referredType) {
        AnnotatedMember ann;
        if (referredType.isJavaLangObject()) {
            return false;
        }
        if (referredType.isFinal()) {
            return true;
        }
        if (referredType.useStaticType()) {
            return true;
        }
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        if (intr != null && property != null && (ann = property.getMember()) != null) {
            JsonSerialize.Typing t = intr.findSerializationTyping(property.getMember());
            if (t == JsonSerialize.Typing.STATIC) {
                return true;
            }
            if (t == JsonSerialize.Typing.DYNAMIC) {
                return false;
            }
        }
        return provider.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, AtomicReference<?> value) {
        if (value == null) {
            return true;
        }
        Object contents = value.get();
        if (contents == null) {
            return true;
        }
        if (this._contentInclusion == null) {
            return false;
        }
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            try {
                ser = this._findCachedSerializer(provider, contents.getClass());
            }
            catch (JsonMappingException e) {
                throw new RuntimeJsonMappingException(e);
            }
        }
        return ser.isEmpty(provider, contents);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return this._unwrapper != null;
    }

    @Override
    public void serialize(AtomicReference<?> ref, JsonGenerator g, SerializerProvider provider) throws IOException {
        Object value = ref.get();
        if (value == null) {
            if (this._unwrapper == null) {
                provider.defaultSerializeNull(g);
            }
            return;
        }
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findCachedSerializer(provider, value.getClass());
        }
        if (this._valueTypeSerializer != null) {
            ser.serializeWithType(value, g, provider, this._valueTypeSerializer);
        } else {
            ser.serialize(value, g, provider);
        }
    }

    @Override
    public void serializeWithType(AtomicReference<?> ref, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        Object value = ref.get();
        if (value == null) {
            if (this._unwrapper == null) {
                provider.defaultSerializeNull(g);
            }
            return;
        }
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findCachedSerializer(provider, value.getClass());
        }
        ser.serializeWithType(value, g, provider, typeSer);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findSerializer(visitor.getProvider(), this._referredType, this._property);
            if (this._unwrapper != null) {
                ser = ser.unwrappingSerializer(this._unwrapper);
            }
        }
        ser.acceptJsonFormatVisitor(visitor, this._referredType);
    }

    private final JsonSerializer<Object> _findCachedSerializer(SerializerProvider provider, Class<?> type) throws JsonMappingException {
        JsonSerializer<Object> ser = this._dynamicSerializers.serializerFor(type);
        if (ser == null) {
            ser = this._findSerializer(provider, type, this._property);
            if (this._unwrapper != null) {
                ser = ser.unwrappingSerializer(this._unwrapper);
            }
            this._dynamicSerializers = this._dynamicSerializers.newWith(type, ser);
        }
        return ser;
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider provider, Class<?> type, BeanProperty prop) throws JsonMappingException {
        return provider.findTypedValueSerializer(type, true, prop);
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider provider, JavaType type, BeanProperty prop) throws JsonMappingException {
        return provider.findTypedValueSerializer(type, true, prop);
    }
}

