/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.fasterxml.jackson.datatype.jdk8;

import com.spotify.ffwd.http.fasterxml.jackson.databind.BeanDescription;
import com.spotify.ffwd.http.fasterxml.jackson.databind.DeserializationConfig;
import com.spotify.ffwd.http.fasterxml.jackson.databind.JavaType;
import com.spotify.ffwd.http.fasterxml.jackson.databind.JsonDeserializer;
import com.spotify.ffwd.http.fasterxml.jackson.databind.deser.Deserializers;
import com.spotify.ffwd.http.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.spotify.ffwd.http.fasterxml.jackson.databind.type.ReferenceType;
import com.spotify.ffwd.http.fasterxml.jackson.datatype.jdk8.OptionalDeserializer;
import com.spotify.ffwd.http.fasterxml.jackson.datatype.jdk8.OptionalDoubleDeserializer;
import com.spotify.ffwd.http.fasterxml.jackson.datatype.jdk8.OptionalIntDeserializer;
import com.spotify.ffwd.http.fasterxml.jackson.datatype.jdk8.OptionalLongDeserializer;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

class Jdk8Deserializers
extends Deserializers.Base {
    Jdk8Deserializers() {
    }

    @Override
    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType refType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) {
        if (refType.hasRawClass(Optional.class)) {
            JavaType valueType = refType.getReferencedType();
            return new OptionalDeserializer(refType, valueType, contentTypeDeserializer, contentDeserializer);
        }
        if (refType.hasRawClass(OptionalInt.class)) {
            return OptionalIntDeserializer.INSTANCE;
        }
        if (refType.hasRawClass(OptionalLong.class)) {
            return OptionalLongDeserializer.INSTANCE;
        }
        if (refType.hasRawClass(OptionalDouble.class)) {
            return OptionalDoubleDeserializer.INSTANCE;
        }
        return null;
    }
}

