/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.fasterxml.jackson.datatype.jdk8;

import com.spotify.ffwd.http.fasterxml.jackson.core.JsonParser;
import com.spotify.ffwd.http.fasterxml.jackson.core.JsonToken;
import com.spotify.ffwd.http.fasterxml.jackson.databind.BeanProperty;
import com.spotify.ffwd.http.fasterxml.jackson.databind.DeserializationContext;
import com.spotify.ffwd.http.fasterxml.jackson.databind.JavaType;
import com.spotify.ffwd.http.fasterxml.jackson.databind.JsonDeserializer;
import com.spotify.ffwd.http.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.ffwd.http.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.spotify.ffwd.http.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.spotify.ffwd.http.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.Optional;

final class OptionalDeserializer
extends StdDeserializer<Optional<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _fullType;
    protected final JavaType _referenceType;
    protected final JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public OptionalDeserializer(JavaType fullType, JavaType refType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        super(fullType);
        this._fullType = fullType;
        this._referenceType = refType;
        this._valueTypeDeserializer = typeDeser;
        this._valueDeserializer = valueDeser;
    }

    @Override
    public Optional<?> getNullValue(DeserializationContext ctxt) {
        return Optional.empty();
    }

    protected OptionalDeserializer withResolved(JavaType refType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        if (refType == this._referenceType && valueDeser == this._valueDeserializer && typeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return new OptionalDeserializer(this._fullType, refType, typeDeser, valueDeser);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        JavaType refType = this._referenceType;
        deser = deser == null ? ctxt.findContextualValueDeserializer(refType, property) : ctxt.handleSecondaryContextualization(deser, property, refType);
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        return this.withResolved(refType, typeDeser, deser);
    }

    @Override
    public Optional<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object refd = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(p, ctxt) : this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        return Optional.ofNullable(refd);
    }

    @Override
    public Optional<?> deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return this.getNullValue(ctxt);
        }
        if (t != null && t.isScalarValue()) {
            return this.deserialize(p, ctxt);
        }
        return (Optional)typeDeserializer.deserializeTypedFromAny(p, ctxt);
    }
}

