/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.fasterxml.jackson.datatype.jdk8;

import com.spotify.ffwd.http.fasterxml.jackson.core.JsonGenerator;
import com.spotify.ffwd.http.fasterxml.jackson.core.JsonParser;
import com.spotify.ffwd.http.fasterxml.jackson.databind.JavaType;
import com.spotify.ffwd.http.fasterxml.jackson.databind.JsonMappingException;
import com.spotify.ffwd.http.fasterxml.jackson.databind.SerializerProvider;
import com.spotify.ffwd.http.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.spotify.ffwd.http.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.spotify.ffwd.http.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.OptionalLong;

final class OptionalLongSerializer
extends StdSerializer<OptionalLong> {
    private static final long serialVersionUID = 1L;
    static final OptionalLongSerializer INSTANCE = new OptionalLongSerializer();

    public OptionalLongSerializer() {
        super(OptionalLong.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, OptionalLong value) {
        return value == null || !value.isPresent();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.LONG);
        }
    }

    @Override
    public void serialize(OptionalLong value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value.isPresent()) {
            jgen.writeNumber(value.getAsLong());
        } else {
            jgen.writeNull();
        }
    }
}

