/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.google.common.cache;

import com.spotify.ffwd.http.google.common.annotations.Beta;
import com.spotify.ffwd.http.google.common.base.Preconditions;
import com.spotify.ffwd.http.google.common.cache.RemovalListener;
import com.spotify.ffwd.http.google.common.cache.RemovalNotification;
import java.util.concurrent.Executor;

@Beta
public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> asynchronous(final RemovalListener<K, V> listener, final Executor executor) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        return new RemovalListener<K, V>(){

            @Override
            public void onRemoval(final RemovalNotification<K, V> notification) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRemoval(notification);
                    }
                });
            }
        };
    }
}

