/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.client;

import com.spotify.ffwd.http.netflix.client.ClientException;
import com.spotify.ffwd.http.netflix.client.ClientRequest;
import com.spotify.ffwd.http.netflix.client.IClient;
import com.spotify.ffwd.http.netflix.client.IClientConfigAware;
import com.spotify.ffwd.http.netflix.client.IResponse;
import com.spotify.ffwd.http.netflix.client.RequestSpecificRetryHandler;
import com.spotify.ffwd.http.netflix.client.config.CommonClientConfigKey;
import com.spotify.ffwd.http.netflix.client.config.IClientConfig;
import com.spotify.ffwd.http.netflix.loadbalancer.ILoadBalancer;
import com.spotify.ffwd.http.netflix.loadbalancer.LoadBalancerContext;
import com.spotify.ffwd.http.netflix.loadbalancer.Server;
import com.spotify.ffwd.http.netflix.loadbalancer.reactive.LoadBalancerCommand;
import com.spotify.ffwd.http.netflix.loadbalancer.reactive.ServerOperation;
import java.net.URI;
import rx.Observable;

public abstract class AbstractLoadBalancerAwareClient<S extends ClientRequest, T extends IResponse>
extends LoadBalancerContext
implements IClient<S, T>,
IClientConfigAware {
    public AbstractLoadBalancerAwareClient(ILoadBalancer lb) {
        super(lb);
    }

    public AbstractLoadBalancerAwareClient(ILoadBalancer lb, IClientConfig clientConfig) {
        super(lb, clientConfig);
    }

    @Deprecated
    protected boolean isCircuitBreakerException(Throwable e) {
        if (this.getRetryHandler() != null) {
            return this.getRetryHandler().isCircuitTrippingException(e);
        }
        return false;
    }

    @Deprecated
    protected boolean isRetriableException(Throwable e) {
        if (this.getRetryHandler() != null) {
            return this.getRetryHandler().isRetriableException(e, true);
        }
        return false;
    }

    public T executeWithLoadBalancer(S request) throws ClientException {
        return this.executeWithLoadBalancer(request, null);
    }

    public T executeWithLoadBalancer(S request, IClientConfig requestConfig) throws ClientException {
        RequestSpecificRetryHandler handler = this.getRequestSpecificRetryHandler(request, requestConfig);
        LoadBalancerCommand command = LoadBalancerCommand.builder().withLoadBalancerContext(this).withRetryHandler(handler).withLoadBalancerURI(((ClientRequest)request).getUri()).build();
        try {
            return (T)((IResponse)command.submit(new ServerOperation<T>((ClientRequest)request, requestConfig){
                final /* synthetic */ ClientRequest val$request;
                final /* synthetic */ IClientConfig val$requestConfig;
                {
                    this.val$request = clientRequest;
                    this.val$requestConfig = iClientConfig;
                }

                @Override
                public Observable<T> call(Server server) {
                    URI finalUri = AbstractLoadBalancerAwareClient.this.reconstructURIWithServer(server, this.val$request.getUri());
                    ClientRequest requestForServer = this.val$request.replaceUri(finalUri);
                    try {
                        return Observable.just(AbstractLoadBalancerAwareClient.this.execute(requestForServer, this.val$requestConfig));
                    }
                    catch (Exception e) {
                        return Observable.error((Throwable)e);
                    }
                }
            }).toBlocking().single());
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t instanceof ClientException) {
                throw (ClientException)t;
            }
            throw new ClientException(e);
        }
    }

    public abstract RequestSpecificRetryHandler getRequestSpecificRetryHandler(S var1, IClientConfig var2);

    @Deprecated
    protected boolean isRetriable(S request) {
        if (((ClientRequest)request).isRetriable()) {
            return true;
        }
        boolean retryOkayOnOperation = this.okToRetryOnAllOperations;
        IClientConfig overriddenClientConfig = ((ClientRequest)request).getOverrideConfig();
        if (overriddenClientConfig != null) {
            retryOkayOnOperation = overriddenClientConfig.getPropertyAsBoolean(CommonClientConfigKey.RequestSpecificRetryOn, this.okToRetryOnAllOperations);
        }
        return retryOkayOnOperation;
    }
}

