/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.client;

import com.spotify.ffwd.http.google.common.collect.Lists;
import com.spotify.ffwd.http.netflix.client.RetryHandler;
import com.spotify.ffwd.http.netflix.client.Utils;
import com.spotify.ffwd.http.netflix.client.config.CommonClientConfigKey;
import com.spotify.ffwd.http.netflix.client.config.IClientConfig;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;

public class DefaultLoadBalancerRetryHandler
implements RetryHandler {
    private List<Class<? extends Throwable>> retriable = Lists.newArrayList(ConnectException.class, SocketTimeoutException.class);
    private List<Class<? extends Throwable>> circuitRelated = Lists.newArrayList(SocketException.class, SocketTimeoutException.class);
    protected final int retrySameServer;
    protected final int retryNextServer;
    protected final boolean retryEnabled;

    public DefaultLoadBalancerRetryHandler() {
        this.retrySameServer = 0;
        this.retryNextServer = 0;
        this.retryEnabled = false;
    }

    public DefaultLoadBalancerRetryHandler(int retrySameServer, int retryNextServer, boolean retryEnabled) {
        this.retrySameServer = retrySameServer;
        this.retryNextServer = retryNextServer;
        this.retryEnabled = retryEnabled;
    }

    public DefaultLoadBalancerRetryHandler(IClientConfig clientConfig) {
        this.retrySameServer = clientConfig.get(CommonClientConfigKey.MaxAutoRetries, 0);
        this.retryNextServer = clientConfig.get(CommonClientConfigKey.MaxAutoRetriesNextServer, 1);
        this.retryEnabled = clientConfig.get(CommonClientConfigKey.OkToRetryOnAllOperations, false);
    }

    @Override
    public boolean isRetriableException(Throwable e, boolean sameServer) {
        if (this.retryEnabled) {
            if (sameServer) {
                return Utils.isPresentAsCause(e, this.getRetriableExceptions());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCircuitTrippingException(Throwable e) {
        return Utils.isPresentAsCause(e, this.getCircuitRelatedExceptions());
    }

    @Override
    public int getMaxRetriesOnSameServer() {
        return this.retrySameServer;
    }

    @Override
    public int getMaxRetriesOnNextServer() {
        return this.retryNextServer;
    }

    protected List<Class<? extends Throwable>> getRetriableExceptions() {
        return this.retriable;
    }

    protected List<Class<? extends Throwable>> getCircuitRelatedExceptions() {
        return this.circuitRelated;
    }
}

