/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.client;

import com.spotify.ffwd.http.google.common.base.Preconditions;
import com.spotify.ffwd.http.google.common.collect.Lists;
import com.spotify.ffwd.http.netflix.client.ClientException;
import com.spotify.ffwd.http.netflix.client.RetryHandler;
import com.spotify.ffwd.http.netflix.client.Utils;
import com.spotify.ffwd.http.netflix.client.config.CommonClientConfigKey;
import com.spotify.ffwd.http.netflix.client.config.IClientConfig;
import java.net.SocketException;
import java.util.List;
import javax.annotation.Nullable;

public class RequestSpecificRetryHandler
implements RetryHandler {
    private final RetryHandler fallback;
    private int retrySameServer = -1;
    private int retryNextServer = -1;
    private final boolean okToRetryOnConnectErrors;
    private final boolean okToRetryOnAllErrors;
    protected List<Class<? extends Throwable>> connectionRelated = Lists.newArrayList(SocketException.class);

    public RequestSpecificRetryHandler(boolean okToRetryOnConnectErrors, boolean okToRetryOnAllErrors) {
        this(okToRetryOnConnectErrors, okToRetryOnAllErrors, RetryHandler.DEFAULT, null);
    }

    public RequestSpecificRetryHandler(boolean okToRetryOnConnectErrors, boolean okToRetryOnAllErrors, RetryHandler baseRetryHandler, @Nullable IClientConfig requestConfig) {
        Preconditions.checkNotNull(baseRetryHandler);
        this.okToRetryOnConnectErrors = okToRetryOnConnectErrors;
        this.okToRetryOnAllErrors = okToRetryOnAllErrors;
        this.fallback = baseRetryHandler;
        if (requestConfig != null) {
            if (requestConfig.containsProperty(CommonClientConfigKey.MaxAutoRetries)) {
                this.retrySameServer = requestConfig.get(CommonClientConfigKey.MaxAutoRetries);
            }
            if (requestConfig.containsProperty(CommonClientConfigKey.MaxAutoRetriesNextServer)) {
                this.retryNextServer = requestConfig.get(CommonClientConfigKey.MaxAutoRetriesNextServer);
            }
        }
    }

    public boolean isConnectionException(Throwable e) {
        return Utils.isPresentAsCause(e, this.connectionRelated);
    }

    @Override
    public boolean isRetriableException(Throwable e, boolean sameServer) {
        if (this.okToRetryOnAllErrors) {
            return true;
        }
        if (e instanceof ClientException) {
            ClientException ce = (ClientException)e;
            if (ce.getErrorType() == ClientException.ErrorType.SERVER_THROTTLED) {
                return !sameServer;
            }
            return false;
        }
        return this.okToRetryOnConnectErrors && this.isConnectionException(e);
    }

    @Override
    public boolean isCircuitTrippingException(Throwable e) {
        return this.fallback.isCircuitTrippingException(e);
    }

    @Override
    public int getMaxRetriesOnSameServer() {
        if (this.retrySameServer >= 0) {
            return this.retrySameServer;
        }
        return this.fallback.getMaxRetriesOnSameServer();
    }

    @Override
    public int getMaxRetriesOnNextServer() {
        if (this.retryNextServer >= 0) {
            return this.retryNextServer;
        }
        return this.fallback.getMaxRetriesOnNextServer();
    }
}

