/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.client;

import com.spotify.ffwd.http.netflix.client.VipAddressResolver;
import com.spotify.ffwd.http.netflix.client.config.IClientConfig;
import com.spotify.ffwd.http.netflix.config.ConfigurationManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleVipAddressResolver
implements VipAddressResolver {
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

    @Override
    public String resolve(String vipAddressMacro, IClientConfig niwsClientConfig) {
        if (vipAddressMacro == null || vipAddressMacro.length() == 0) {
            return vipAddressMacro;
        }
        return SimpleVipAddressResolver.replaceMacrosFromConfig(vipAddressMacro);
    }

    private static String replaceMacrosFromConfig(String macro) {
        String result = macro;
        Matcher matcher = VAR_PATTERN.matcher(result);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = ConfigurationManager.getConfigInstance().getString(key);
            if (value == null) continue;
            result = result.replaceAll("\\$\\{" + key + "\\}", value);
            matcher = VAR_PATTERN.matcher(result);
        }
        return result.trim();
    }
}

