/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.client.ssl;

import com.spotify.ffwd.http.netflix.client.ssl.ClientSslSocketFactoryException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSslContextFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSslContextFactory.class);
    public static final String SOCKET_ALGORITHM = "SSL";
    private KeyStore keyStore;
    private KeyStore trustStore;
    private String keyStorePassword;
    private final int trustStorePasswordLength;
    private final int keyStorePasswordLength;

    protected AbstractSslContextFactory(KeyStore trustStore, String trustStorePassword, KeyStore keyStore, String keyStorePassword) {
        this.trustStore = trustStore;
        this.keyStorePassword = keyStorePassword;
        this.keyStore = keyStore;
        this.keyStorePasswordLength = keyStorePassword != null ? keyStorePassword.length() : -1;
        this.trustStorePasswordLength = trustStorePassword != null ? trustStorePassword.length() : -1;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public int getKeyStorePasswordLength() {
        return this.keyStorePasswordLength;
    }

    public int getTrustStorePasswordLength() {
        return this.trustStorePasswordLength;
    }

    private SSLContext createSSLContext() throws ClientSslSocketFactoryException {
        KeyManager[] keyManagers = this.keyStore != null ? this.createKeyManagers() : null;
        TrustManager[] trustManagers = this.trustStore != null ? this.createTrustManagers() : null;
        try {
            SSLContext sslcontext = SSLContext.getInstance(SOCKET_ALGORITHM);
            sslcontext.init(keyManagers, trustManagers, null);
            return sslcontext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientSslSocketFactoryException(String.format("Failed to create an SSL context that supports algorithm %s: %s", SOCKET_ALGORITHM, e.getMessage()), e);
        }
        catch (KeyManagementException e) {
            throw new ClientSslSocketFactoryException(String.format("Failed to initialize an SSL context: %s", e.getMessage()), e);
        }
    }

    private KeyManager[] createKeyManagers() throws ClientSslSocketFactoryException {
        KeyManagerFactory factory;
        try {
            factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(this.keyStore, this.keyStorePassword.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientSslSocketFactoryException(String.format("Failed to create the key store because the algorithm %s is not supported. ", KeyManagerFactory.getDefaultAlgorithm()), e);
        }
        catch (UnrecoverableKeyException e) {
            throw new ClientSslSocketFactoryException("Unrecoverable Key Exception initializing key manager factory; this is probably fatal", e);
        }
        catch (KeyStoreException e) {
            throw new ClientSslSocketFactoryException("KeyStore exception initializing key manager factory; this is probably fatal", e);
        }
        KeyManager[] managers = factory.getKeyManagers();
        LOGGER.debug("Key managers are initialized. Total {} managers. ", (Object)managers.length);
        return managers;
    }

    private TrustManager[] createTrustManagers() throws ClientSslSocketFactoryException {
        TrustManagerFactory factory;
        try {
            factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(this.trustStore);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientSslSocketFactoryException(String.format("Failed to create the trust store because the algorithm %s is not supported. ", KeyManagerFactory.getDefaultAlgorithm()), e);
        }
        catch (KeyStoreException e) {
            throw new ClientSslSocketFactoryException("KeyStore exception initializing trust manager factory; this is probably fatal", e);
        }
        TrustManager[] managers = factory.getTrustManagers();
        LOGGER.debug("TrustManagers are initialized. Total {} managers: ", (Object)managers.length);
        return managers;
    }

    public SSLContext getSSLContext() throws ClientSslSocketFactoryException {
        return this.createSSLContext();
    }
}

