/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.config;

import com.spotify.ffwd.http.netflix.config.ConcurrentMapConfiguration;
import com.spotify.ffwd.http.netflix.config.ConfigurationManager;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathPropertiesConfiguration
extends ConcurrentMapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ClasspathPropertiesConfiguration.class);
    static String propertiesResourceRelativePath = "META-INF/conf/config.properties";
    static ClasspathPropertiesConfiguration instance = null;
    @Deprecated
    static String configNameProperty = "config.configName";

    private ClasspathPropertiesConfiguration() {
    }

    @Deprecated
    public String getConfigNameProperty() {
        return configNameProperty;
    }

    @Deprecated
    public static void setConfigNameProperty(String configNameProperty) {
        ClasspathPropertiesConfiguration.configNameProperty = configNameProperty;
    }

    public String getPropertiesResourceRelativePath() {
        return propertiesResourceRelativePath;
    }

    public static void setPropertiesResourceRelativePath(String propertiesResourceRelativePath) {
        ClasspathPropertiesConfiguration.propertiesResourceRelativePath = propertiesResourceRelativePath;
    }

    @Override
    public Properties getProperties() {
        return instance != null ? instance.getProperties() : new Properties();
    }

    public static void initialize() {
        try {
            instance = new ClasspathPropertiesConfiguration();
            ClasspathPropertiesConfiguration.loadResources(propertiesResourceRelativePath);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to read configuration properties from classpath", e);
        }
    }

    private static void loadResources(String resourceName) throws Exception {
        ConfigurationManager.loadPropertiesFromResources(resourceName);
        log.debug("Added properties from:" + resourceName);
    }
}

