/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.config;

import com.spotify.ffwd.http.commons.configuration.AbstractConfiguration;
import com.spotify.ffwd.http.netflix.config.DynamicPropertySupport;
import com.spotify.ffwd.http.netflix.config.ExpandedConfigurationListenerAdapter;
import com.spotify.ffwd.http.netflix.config.PropertyListener;

public class ConfigurationBackedDynamicPropertySupportImpl
implements DynamicPropertySupport {
    private final AbstractConfiguration config;

    public ConfigurationBackedDynamicPropertySupportImpl(AbstractConfiguration config) {
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        this.config = config;
    }

    @Override
    public String getString(String key) {
        try {
            String[] values = this.config.getStringArray(key);
            if (values == null) {
                return null;
            }
            if (values.length == 0) {
                return this.config.getString(key);
            }
            if (values.length == 1) {
                return values[0];
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                sb.append(values[i]);
                if (i == values.length - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        catch (Exception e) {
            Object v = this.config.getProperty(key);
            if (v != null) {
                return String.valueOf(v);
            }
            return null;
        }
    }

    @Override
    public void addConfigurationListener(PropertyListener expandedConfigListener) {
        ExpandedConfigurationListenerAdapter nl = new ExpandedConfigurationListenerAdapter(expandedConfigListener);
        this.config.addConfigurationListener(nl);
    }

    public final AbstractConfiguration getConfiguration() {
        return this.config;
    }
}

