/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.config;

import com.spotify.ffwd.http.commons.configuration.AbstractConfiguration;
import com.spotify.ffwd.http.commons.configuration.Configuration;
import com.spotify.ffwd.http.commons.configuration.EnvironmentConfiguration;
import com.spotify.ffwd.http.commons.configuration.SystemConfiguration;
import com.spotify.ffwd.http.commons.configuration.event.ConfigurationListener;
import com.spotify.ffwd.http.netflix.config.AggregatedConfiguration;
import com.spotify.ffwd.http.netflix.config.ConcurrentCompositeConfiguration;
import com.spotify.ffwd.http.netflix.config.ConcurrentMapConfiguration;
import com.spotify.ffwd.http.netflix.config.ConfigurationBasedDeploymentContext;
import com.spotify.ffwd.http.netflix.config.DeploymentContext;
import com.spotify.ffwd.http.netflix.config.DynamicProperty;
import com.spotify.ffwd.http.netflix.config.DynamicPropertyFactory;
import com.spotify.ffwd.http.netflix.config.DynamicURLConfiguration;
import com.spotify.ffwd.http.netflix.config.ExpandedConfigurationListenerAdapter;
import com.spotify.ffwd.http.netflix.config.jmx.ConfigJMXManager;
import com.spotify.ffwd.http.netflix.config.jmx.ConfigMBean;
import com.spotify.ffwd.http.netflix.config.util.ConfigurationUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    static volatile AbstractConfiguration instance = null;
    static volatile boolean customConfigurationInstalled = false;
    private static volatile ConfigMBean configMBean = null;
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationManager.class);
    static volatile DeploymentContext context = null;
    public static final String PROP_NEXT_LOAD = "@next";
    public static final String URL_CONFIG_NAME = "archaius.dynamicPropertyFactory.URL_CONFIG";
    public static final String SYS_CONFIG_NAME = "archaius.dynamicPropertyFactory.SYS_CONFIG";
    public static final String ENV_CONFIG_NAME = "archaius.dynamicPropertyFactory.ENV_CONFIG";
    public static final String DISABLE_DEFAULT_ENV_CONFIG = "archaius.dynamicProperty.disableEnvironmentConfig";
    public static final String DISABLE_DEFAULT_SYS_CONFIG = "archaius.dynamicProperty.disableSystemConfig";
    private static final String PROP_NEXT_LOAD_NFLX = "netflixconfiguration.properties.nextLoad";
    public static final String APPLICATION_PROPERTIES = "APPLICATION_PROPERTIES";
    private static Set<String> loadedPropertiesURLs = new CopyOnWriteArraySet<String>();

    public static Set<String> getLoadedPropertiesURLs() {
        return loadedPropertiesURLs;
    }

    public static synchronized void install(AbstractConfiguration config) throws IllegalStateException {
        if (!customConfigurationInstalled) {
            ConfigurationManager.setDirect(config);
            if (DynamicPropertyFactory.getBackingConfigurationSource() != config) {
                DynamicPropertyFactory.initWithConfigurationSource(config);
            }
        } else {
            throw new IllegalStateException("A non-default configuration is already installed");
        }
    }

    public static synchronized boolean isConfigurationInstalled() {
        return customConfigurationInstalled;
    }

    private static AbstractConfiguration createDefaultConfigInstance() {
        ConcurrentCompositeConfiguration config = new ConcurrentCompositeConfiguration();
        try {
            DynamicURLConfiguration defaultURLConfig = new DynamicURLConfiguration();
            config.addConfiguration(defaultURLConfig, URL_CONFIG_NAME);
        }
        catch (Throwable e) {
            logger.warn("Failed to create default dynamic configuration", e);
        }
        if (!Boolean.getBoolean(DISABLE_DEFAULT_SYS_CONFIG)) {
            SystemConfiguration sysConfig = new SystemConfiguration();
            config.addConfiguration(sysConfig, SYS_CONFIG_NAME);
        }
        if (!Boolean.getBoolean(DISABLE_DEFAULT_ENV_CONFIG)) {
            EnvironmentConfiguration envConfig = new EnvironmentConfiguration();
            config.addConfiguration(envConfig, ENV_CONFIG_NAME);
        }
        ConcurrentCompositeConfiguration appOverrideConfig = new ConcurrentCompositeConfiguration();
        config.addConfiguration(appOverrideConfig, APPLICATION_PROPERTIES);
        config.setContainerConfigurationIndex(config.getIndexOfConfiguration(appOverrideConfig));
        return config;
    }

    private static AbstractConfiguration getConfigInstance(boolean defaultConfigDisabled) {
        if (instance == null && !defaultConfigDisabled) {
            instance = ConfigurationManager.createDefaultConfigInstance();
            ConfigurationManager.registerConfigBean();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractConfiguration getConfigInstance() {
        if (instance != null) return instance;
        Class<ConfigurationManager> clazz = ConfigurationManager.class;
        synchronized (ConfigurationManager.class) {
            if (instance != null) return instance;
            instance = ConfigurationManager.getConfigInstance(Boolean.getBoolean("archaius.dynamicProperty.disableDefaultConfig"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerConfigBean() {
        if (Boolean.getBoolean("archaius.dynamicPropertyFactory.registerConfigWithJMX")) {
            try {
                configMBean = ConfigJMXManager.registerConfigMbean(instance);
            }
            catch (Exception e) {
                logger.error("Unable to register with JMX", (Throwable)e);
            }
        }
    }

    static synchronized void setDirect(AbstractConfiguration config) {
        if (instance != null) {
            Collection<ConfigurationListener> listeners = instance.getConfigurationListeners();
            Iterator<String> i = instance.getKeys();
            while (i.hasNext()) {
                String key = i.next();
                Object value = instance.getProperty(key);
                if (value == null || config.containsKey(key)) continue;
                config.setProperty(key, value);
            }
            if (listeners != null) {
                for (ConfigurationListener listener : listeners) {
                    if (listener instanceof ExpandedConfigurationListenerAdapter && ((ExpandedConfigurationListenerAdapter)listener).getListener() instanceof DynamicProperty.DynamicPropertyListener) continue;
                    config.addConfigurationListener(listener);
                }
            }
        }
        ConfigurationManager.removeDefaultConfiguration();
        instance = config;
        customConfigurationInstalled = true;
        ConfigurationManager.registerConfigBean();
    }

    public static void loadPropertiesFromResources(String path) throws IOException {
        ClassLoader loader;
        Enumeration<URL> resources;
        if (instance == null) {
            instance = ConfigurationManager.getConfigInstance();
        }
        if (!(resources = (loader = Thread.currentThread().getContextClassLoader()).getResources(path)).hasMoreElements()) {
            throw new IOException("Cannot locate " + path + " as a classpath resource.");
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            InputStream fin = url.openStream();
            Properties props = ConfigurationUtils.loadPropertiesFromInputStream(fin);
            if (instance instanceof AggregatedConfiguration) {
                String name = ConfigurationManager.getConfigName(url);
                ConcurrentMapConfiguration config = new ConcurrentMapConfiguration();
                config.loadProperties(props);
                ((AggregatedConfiguration)((Object)instance)).addConfiguration(config, name);
                continue;
            }
            ConfigurationUtils.loadProperties(props, instance);
        }
    }

    public static void loadCascadedPropertiesFromResources(String configName) throws IOException {
        Properties props = ConfigurationManager.loadCascadedProperties(configName);
        if (instance instanceof AggregatedConfiguration) {
            ConcurrentMapConfiguration config = new ConcurrentMapConfiguration();
            config.loadProperties(props);
            ((AggregatedConfiguration)((Object)instance)).addConfiguration(config, configName);
        } else {
            ConfigurationUtils.loadProperties(props, instance);
        }
    }

    private static Properties loadCascadedProperties(String configName) throws IOException {
        Properties envProps;
        String envConfigFileName;
        ClassLoader loader;
        URL url;
        String defaultConfigFileName = configName + ".properties";
        if (instance == null) {
            instance = ConfigurationManager.getConfigInstance();
        }
        if ((url = (loader = Thread.currentThread().getContextClassLoader()).getResource(defaultConfigFileName)) == null) {
            throw new IOException("Cannot locate " + defaultConfigFileName + " as a classpath resource.");
        }
        Properties props = ConfigurationManager.getPropertiesFromFile(url);
        String environment = ConfigurationManager.getDeploymentContext().getDeploymentEnvironment();
        if (environment != null && environment.length() > 0 && (url = loader.getResource(envConfigFileName = configName + "-" + environment + ".properties")) != null && (envProps = ConfigurationManager.getPropertiesFromFile(url)) != null) {
            props.putAll((Map<?, ?>)envProps);
        }
        return props;
    }

    public static void loadAppOverrideProperties(String appConfigName) throws IOException {
        AggregatedConfiguration aggregated;
        Configuration appConfig;
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        Properties props = ConfigurationManager.loadCascadedProperties(appConfigName);
        if (config instanceof AggregatedConfiguration && (appConfig = (aggregated = (AggregatedConfiguration)((Object)config)).getConfiguration(APPLICATION_PROPERTIES)) != null) {
            ConfigurationUtils.loadProperties(props, appConfig);
            return;
        }
        ConfigurationUtils.loadProperties(props, config);
    }

    public static void loadPropertiesFromConfiguration(AbstractConfiguration config) {
        if (instance == null) {
            instance = ConfigurationManager.getConfigInstance();
        }
        if (instance instanceof AggregatedConfiguration) {
            ((AggregatedConfiguration)((Object)instance)).addConfiguration(config);
        } else {
            Properties props = ConfigurationUtils.getProperties(config);
            ConfigurationUtils.loadProperties(props, instance);
        }
    }

    public static void loadProperties(Properties properties) {
        if (instance == null) {
            instance = ConfigurationManager.getConfigInstance();
        }
        ConfigurationUtils.loadProperties(properties, instance);
    }

    public static void setDeploymentContext(DeploymentContext context) {
        ConfigurationManager.context = context;
        if (ConfigurationManager.getConfigInstance() == null) {
            return;
        }
        for (DeploymentContext.ContextKey key : DeploymentContext.ContextKey.values()) {
            String value = context.getValue(key);
            if (value == null) continue;
            instance.setProperty(key.getKey(), value);
        }
    }

    public static DeploymentContext getDeploymentContext() {
        return context;
    }

    private static String getConfigName(URL propertyFile) {
        String name = propertyFile.toExternalForm();
        name = name.replace('\\', '/');
        String scheme = propertyFile.getProtocol().toLowerCase();
        if ("jar".equals(scheme) || "zip".equals(scheme)) {
            int slash;
            int bang = name.lastIndexOf("!");
            if (bang >= 0) {
                name = name.substring(0, bang);
            }
            if ((slash = name.lastIndexOf("/")) >= 0) {
                name = name.substring(slash + 1);
            }
        } else {
            int slash = name.lastIndexOf("/");
            if (slash >= 0) {
                name = name.substring(0, slash);
            }
        }
        return name;
    }

    private static synchronized void removeDefaultConfiguration() {
        if (instance == null || customConfigurationInstalled) {
            return;
        }
        ConcurrentCompositeConfiguration defaultConfig = (ConcurrentCompositeConfiguration)instance;
        DynamicURLConfiguration defaultFileConfig = (DynamicURLConfiguration)defaultConfig.getConfiguration(URL_CONFIG_NAME);
        if (defaultFileConfig != null) {
            defaultFileConfig.stopLoading();
        }
        Collection<ConfigurationListener> listeners = defaultConfig.getConfigurationListeners();
        ConfigurationListener dynamicPropertyListener = null;
        for (ConfigurationListener l : listeners) {
            if (!(l instanceof ExpandedConfigurationListenerAdapter) || !(((ExpandedConfigurationListenerAdapter)l).getListener() instanceof DynamicProperty.DynamicPropertyListener)) continue;
            dynamicPropertyListener = l;
            break;
        }
        if (dynamicPropertyListener != null) {
            defaultConfig.removeConfigurationListener(dynamicPropertyListener);
        }
        if (configMBean != null) {
            try {
                ConfigJMXManager.unRegisterConfigMBean(defaultConfig, configMBean);
            }
            catch (Exception e) {
                logger.error("Error unregistering with JMX", (Throwable)e);
            }
        }
        instance = null;
    }

    public static AbstractConfiguration getConfigFromPropertiesFile(URL startingUrl) throws FileNotFoundException {
        return ConfigurationUtils.getConfigFromPropertiesFile(startingUrl, ConfigurationManager.getLoadedPropertiesURLs(), PROP_NEXT_LOAD, PROP_NEXT_LOAD_NFLX);
    }

    public static Properties getPropertiesFromFile(URL startingUrl) throws FileNotFoundException {
        return ConfigurationUtils.getPropertiesFromFile(startingUrl, ConfigurationManager.getLoadedPropertiesURLs(), PROP_NEXT_LOAD, PROP_NEXT_LOAD_NFLX);
    }

    static {
        try {
            String className = System.getProperty("archaius.default.configuration.class");
            if (className != null) {
                instance = (AbstractConfiguration)Class.forName(className).newInstance();
                customConfigurationInstalled = true;
            } else {
                String factoryName = System.getProperty("archaius.default.configuration.factory");
                if (factoryName != null) {
                    Method m = Class.forName(factoryName).getDeclaredMethod("getInstance", new Class[0]);
                    m.setAccessible(true);
                    instance = (AbstractConfiguration)m.invoke(null, new Object[0]);
                    customConfigurationInstalled = true;
                }
            }
            String contextClassName = System.getProperty("archaius.default.deploymentContext.class");
            if (contextClassName != null) {
                ConfigurationManager.setDeploymentContext((DeploymentContext)Class.forName(contextClassName).newInstance());
            } else {
                String factoryName = System.getProperty("archaius.default.deploymentContext.factory");
                if (factoryName != null) {
                    Method m = Class.forName(factoryName).getDeclaredMethod("getInstance", new Class[0]);
                    m.setAccessible(true);
                    ConfigurationManager.setDeploymentContext((DeploymentContext)m.invoke(null, new Object[0]));
                } else {
                    ConfigurationManager.setDeploymentContext(new ConfigurationBasedDeploymentContext());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing configuration", e);
        }
    }
}

