/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.config;

import com.spotify.ffwd.http.google.common.base.Function;
import com.spotify.ffwd.http.google.common.base.Predicate;
import com.spotify.ffwd.http.netflix.config.DynamicProperty;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public class DefaultContextualPredicate
implements Predicate<Map<String, Collection<String>>> {
    private final Function<String, String> getValueFromKeyFunction;
    public static final DefaultContextualPredicate PROPERTY_BASED = new DefaultContextualPredicate(new Function<String, String>(){

        @Override
        public String apply(@Nullable String input) {
            return DynamicProperty.getInstance(input).getString();
        }
    });

    public DefaultContextualPredicate(Function<String, String> getValueFromKeyFunction) {
        this.getValueFromKeyFunction = getValueFromKeyFunction;
    }

    @Override
    public boolean apply(@Nullable Map<String, Collection<String>> input) {
        if (null == input) {
            throw new NullPointerException();
        }
        for (Map.Entry<String, Collection<String>> entry : input.entrySet()) {
            String key = entry.getKey();
            Collection<String> value = entry.getValue();
            if (value.contains(this.getValueFromKeyFunction.apply(key))) continue;
            return false;
        }
        return true;
    }
}

