/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.config;

import com.spotify.ffwd.http.google.common.collect.Lists;
import com.spotify.ffwd.http.netflix.config.DynamicPropertyFactory;
import com.spotify.ffwd.http.netflix.config.DynamicStringProperty;
import com.spotify.ffwd.http.netflix.config.Property;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DerivedStringProperty<D>
implements Property<D> {
    private static final Logger log = LoggerFactory.getLogger(DerivedStringProperty.class);
    private final DynamicStringProperty delegate;
    private final List<Runnable> callbackList = Lists.newArrayList();
    private final AtomicReference<D> derived = new AtomicReference<Object>(null);

    public DerivedStringProperty(String name, String defaultValue) {
        this.delegate = DynamicPropertyFactory.getInstance().getStringProperty(name, defaultValue);
        this.deriveAndSet();
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                DerivedStringProperty.this.propertyChangedInternal();
            }
        };
        this.delegate.addCallback(callback);
        this.callbackList.add(callback);
    }

    public D get() {
        return this.derived.get();
    }

    @Override
    public D getValue() {
        return this.get();
    }

    @Override
    public D getDefaultValue() {
        return this.derive((String)this.delegate.getDefaultValue());
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public long getChangedTimestamp() {
        return this.delegate.getChangedTimestamp();
    }

    @Override
    public void addCallback(Runnable callback) {
        this.delegate.addCallback(callback);
        this.callbackList.add(callback);
    }

    @Override
    public void removeAllCallbacks() {
        for (Runnable callback : this.callbackList) {
            this.delegate.prop.removeCallback(callback);
        }
    }

    protected abstract D derive(String var1);

    protected void propertyChanged() {
    }

    void propertyChangedInternal() {
        this.deriveAndSet();
        this.propertyChanged();
    }

    private void deriveAndSet() {
        try {
            this.derived.set(this.derive(this.delegate.get()));
        }
        catch (Exception e) {
            log.error("error when deriving initial value", (Throwable)e);
        }
    }
}

