/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.config;

import com.spotify.ffwd.http.google.common.base.Splitter;
import com.spotify.ffwd.http.google.common.base.Strings;
import com.spotify.ffwd.http.google.common.collect.Lists;
import com.spotify.ffwd.http.netflix.config.DynamicPropertyFactory;
import com.spotify.ffwd.http.netflix.config.DynamicStringProperty;
import com.spotify.ffwd.http.netflix.config.Property;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class DynamicListProperty<T>
implements Property<List<T>> {
    private volatile List<T> values;
    private List<T> defaultValues;
    private DynamicStringProperty delegate;
    private Splitter splitter;
    public static final String DEFAULT_DELIMITER = ",";

    public DynamicListProperty(String propName, String defaultValue) {
        this(propName, defaultValue, DEFAULT_DELIMITER);
    }

    public DynamicListProperty(String propName, String defaultValue, String delimiterRegex) {
        this.splitter = Splitter.onPattern(delimiterRegex).omitEmptyStrings().trimResults();
        this.setup(propName, this.transform(this.split(defaultValue)), this.splitter);
    }

    public DynamicListProperty(String propName, List<T> defaultValue) {
        this(propName, defaultValue, DEFAULT_DELIMITER);
    }

    public DynamicListProperty(String propName, List<T> defaultValue, String delimiterRegex) {
        this.setup(propName, defaultValue, delimiterRegex);
    }

    public DynamicListProperty(String propName, List<T> defaultValue, Splitter splitter) {
        this.setup(propName, defaultValue, splitter);
    }

    private void setup(String propName, List<T> defaultValue, String delimiterRegex) {
        this.setup(propName, defaultValue, Splitter.onPattern(delimiterRegex).omitEmptyStrings().trimResults());
    }

    private void setup(String propName, List<T> defaultValue, Splitter splitter) {
        this.defaultValues = defaultValue == null ? null : Collections.unmodifiableList(new ArrayList<T>(defaultValue));
        this.splitter = splitter;
        this.delegate = DynamicPropertyFactory.getInstance().getStringProperty(propName, null);
        this.load();
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                DynamicListProperty.this.propertyChangedInternal();
            }
        };
        this.delegate.addCallback(callback);
    }

    private void propertyChangedInternal() {
        this.load();
        this.propertyChanged();
    }

    protected void propertyChanged() {
    }

    public List<T> get() {
        return this.values;
    }

    @Override
    public List<T> getValue() {
        return this.get();
    }

    @Override
    public List<T> getDefaultValue() {
        return this.defaultValues;
    }

    private List<String> split(String value) {
        return Lists.newArrayList(this.splitter.split(Strings.nullToEmpty(value)));
    }

    protected List<T> transform(List<String> stringValues) {
        ArrayList<T> list = new ArrayList<T>(stringValues.size());
        for (String s : stringValues) {
            list.add(this.from(s));
        }
        return Collections.unmodifiableList(list);
    }

    protected void load() {
        this.values = this.delegate.get() == null ? this.defaultValues : this.transform(this.split(this.delegate.get()));
    }

    @Override
    public long getChangedTimestamp() {
        return this.delegate.getChangedTimestamp();
    }

    @Override
    public void addCallback(Runnable callback) {
        if (callback != null) {
            this.delegate.addCallback(callback);
        }
    }

    @Override
    public void removeAllCallbacks() {
        this.delegate.removeAllCallbacks();
    }

    protected abstract T from(String var1);

    @Override
    public String getName() {
        return this.delegate.getName();
    }
}

