/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.config;

import com.spotify.ffwd.http.netflix.config.ConcurrentMapConfiguration;
import com.spotify.ffwd.http.netflix.config.DynamicPropertyUpdater;
import com.spotify.ffwd.http.netflix.config.WatchedConfigurationSource;
import com.spotify.ffwd.http.netflix.config.WatchedUpdateListener;
import com.spotify.ffwd.http.netflix.config.WatchedUpdateResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicWatchedConfiguration
extends ConcurrentMapConfiguration
implements WatchedUpdateListener {
    private final WatchedConfigurationSource source;
    private final boolean ignoreDeletesFromSource;
    private final DynamicPropertyUpdater updater;
    private static final Logger logger = LoggerFactory.getLogger(DynamicWatchedConfiguration.class);

    public DynamicWatchedConfiguration(WatchedConfigurationSource source, boolean ignoreDeletesFromSource, DynamicPropertyUpdater updater) {
        this.source = source;
        this.ignoreDeletesFromSource = ignoreDeletesFromSource;
        this.updater = updater;
        try {
            Map<String, Object> currentData = source.getCurrentData();
            WatchedUpdateResult result = WatchedUpdateResult.createFull(currentData);
            this.updateConfiguration(result);
        }
        catch (Exception exc) {
            logger.error("could not getCurrentData() from the WatchedConfigurationSource", (Throwable)exc);
        }
        this.source.addUpdateListener(this);
    }

    public DynamicWatchedConfiguration(WatchedConfigurationSource source) {
        this(source, false, new DynamicPropertyUpdater());
    }

    @Override
    public void updateConfiguration(WatchedUpdateResult result) {
        this.updater.updateProperties(result, this, this.ignoreDeletesFromSource);
    }

    public boolean isIgnoreDeletesFromSource() {
        return this.ignoreDeletesFromSource;
    }

    public WatchedConfigurationSource getSource() {
        return this.source;
    }
}

