/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.config;

import com.spotify.ffwd.http.commons.configuration.event.ConfigurationEvent;
import com.spotify.ffwd.http.commons.configuration.event.ConfigurationListener;
import com.spotify.ffwd.http.netflix.config.PropertyListener;

public class ExpandedConfigurationListenerAdapter
implements ConfigurationListener {
    private PropertyListener expandedListener;
    static volatile boolean pauseListener;

    public static boolean isListenerPaused() {
        return pauseListener;
    }

    public static void setPauseListener(boolean pauseListener) {
        ExpandedConfigurationListenerAdapter.pauseListener = pauseListener;
    }

    public ExpandedConfigurationListenerAdapter(PropertyListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener cannot be null.");
        }
        this.expandedListener = listener;
    }

    public PropertyListener getListener() {
        return this.expandedListener;
    }

    @Override
    public void configurationChanged(ConfigurationEvent event) {
        if (pauseListener) {
            return;
        }
        Object source = event.getSource();
        String name = event.getPropertyName();
        Object value = event.getPropertyValue();
        boolean beforeUpdate = event.isBeforeUpdate();
        switch (event.getType()) {
            case 11: 
            case 10001: {
                this.expandedListener.configSourceLoaded(source);
                break;
            }
            case 1: {
                this.expandedListener.addProperty(source, name, value, beforeUpdate);
                break;
            }
            case 4: {
                this.expandedListener.clear(source, beforeUpdate);
                break;
            }
            case 2: {
                this.expandedListener.clearProperty(source, name, value, beforeUpdate);
                break;
            }
            case 10: {
                break;
            }
            case 40: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                this.expandedListener.setProperty(source, name, value, beforeUpdate);
                break;
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExpandedConfigurationListenerAdapter) {
            ExpandedConfigurationListenerAdapter that = (ExpandedConfigurationListenerAdapter)obj;
            return this.expandedListener.equals(that.expandedListener);
        }
        return false;
    }

    public int hashCode() {
        return this.expandedListener.hashCode();
    }
}

