/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.config;

import java.util.Map;

public class WatchedUpdateResult {
    protected final Map<String, Object> complete;
    protected final Map<String, Object> added;
    protected final Map<String, Object> changed;
    protected final Map<String, Object> deleted;
    protected final boolean incremental;

    public static WatchedUpdateResult createFull(Map<String, Object> complete) {
        return new WatchedUpdateResult(complete);
    }

    public static WatchedUpdateResult createIncremental(Map<String, Object> added, Map<String, Object> changed, Map<String, Object> deleted) {
        return new WatchedUpdateResult(added, changed, deleted);
    }

    public boolean hasChanges() {
        if (this.incremental) {
            return this.added != null && this.added.size() > 0 || this.changed != null && this.changed.size() > 0 || this.deleted != null && this.deleted.size() > 0;
        }
        return this.complete != null;
    }

    public final Map<String, Object> getComplete() {
        return this.complete;
    }

    public final Map<String, Object> getAdded() {
        return this.added;
    }

    public final Map<String, Object> getChanged() {
        return this.changed;
    }

    public final Map<String, Object> getDeleted() {
        return this.deleted;
    }

    public final boolean isIncremental() {
        return this.incremental;
    }

    WatchedUpdateResult(Map<String, Object> complete) {
        this.complete = complete;
        this.added = null;
        this.changed = null;
        this.deleted = null;
        this.incremental = false;
    }

    WatchedUpdateResult(Map<String, Object> added, Map<String, Object> changed, Map<String, Object> deleted) {
        this.complete = null;
        this.added = added;
        this.changed = changed;
        this.deleted = deleted;
        this.incremental = true;
    }
}

