/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.config.jmx;

import com.spotify.ffwd.http.commons.configuration.AbstractConfiguration;
import com.spotify.ffwd.http.netflix.config.jmx.BaseConfigMBean;
import com.spotify.ffwd.http.netflix.config.jmx.ConfigMBean;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class ConfigJMXManager {
    public static ConfigMBean registerConfigMbean(AbstractConfiguration config) {
        StandardMBean mbean = null;
        BaseConfigMBean bean = null;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            bean = new BaseConfigMBean(config);
            mbean = new StandardMBean(bean, ConfigMBean.class);
            mbs.registerMBean(mbean, ConfigJMXManager.getJMXObjectName(config, bean));
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("NotCompliantMBeanException", e);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new RuntimeException("InstanceAlreadyExistsException", e);
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException("MBeanRegistrationException", e);
        }
        catch (Exception e) {
            throw new RuntimeException("registerConfigMbeanException", e);
        }
        return bean;
    }

    public static void unRegisterConfigMBean(AbstractConfiguration config, ConfigMBean mbean) {
        if (mbean == null) {
            throw new RuntimeException("Cannot unregister JMX Mbean. The object is null");
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.unregisterMBean(ConfigJMXManager.getJMXObjectName(config, mbean));
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException("InstanceNotFoundException", e);
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException("MBeanRegistrationException", e);
        }
        catch (Exception e) {
            throw new RuntimeException("unRegisterConfigMBeanException", e);
        }
    }

    private static ObjectName getJMXObjectName(AbstractConfiguration config, ConfigMBean bean) throws Exception {
        try {
            Class<?> c = bean.getClass();
            String className = c.getName();
            int lastDot = className.lastIndexOf(46);
            ObjectName name = new ObjectName("Config-" + className.substring(0, lastDot) + ":class=" + className.substring(lastDot + 1));
            return name;
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("MalformedObjectNameException", e);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("NullPointerException", e);
        }
    }
}

