/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.loadbalancer;

import com.spotify.ffwd.http.google.common.base.Optional;
import com.spotify.ffwd.http.google.common.base.Predicate;
import com.spotify.ffwd.http.google.common.collect.ImmutableList;
import com.spotify.ffwd.http.google.common.collect.Iterables;
import com.spotify.ffwd.http.google.common.collect.Lists;
import com.spotify.ffwd.http.netflix.client.config.IClientConfig;
import com.spotify.ffwd.http.netflix.loadbalancer.AbstractLoadBalancer;
import com.spotify.ffwd.http.netflix.loadbalancer.ILoadBalancer;
import com.spotify.ffwd.http.netflix.loadbalancer.IRule;
import com.spotify.ffwd.http.netflix.loadbalancer.LoadBalancerStats;
import com.spotify.ffwd.http.netflix.loadbalancer.PredicateKey;
import com.spotify.ffwd.http.netflix.loadbalancer.Server;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public abstract class AbstractServerPredicate
implements Predicate<PredicateKey> {
    protected IRule rule;
    private volatile LoadBalancerStats lbStats;
    private final Random random = new Random();
    private final AtomicInteger nextIndex = new AtomicInteger();
    private final Predicate<Server> serverOnlyPredicate = new Predicate<Server>(){

        @Override
        public boolean apply(@Nullable Server input) {
            return AbstractServerPredicate.this.apply(new PredicateKey(input));
        }
    };

    public static AbstractServerPredicate alwaysTrue() {
        return new AbstractServerPredicate(){

            @Override
            public boolean apply(@Nullable PredicateKey input) {
                return true;
            }
        };
    }

    public AbstractServerPredicate() {
    }

    public AbstractServerPredicate(IRule rule) {
        this.rule = rule;
    }

    public AbstractServerPredicate(IRule rule, IClientConfig clientConfig) {
        this.rule = rule;
    }

    public AbstractServerPredicate(LoadBalancerStats lbStats, IClientConfig clientConfig) {
        this.lbStats = lbStats;
    }

    protected LoadBalancerStats getLBStats() {
        if (this.lbStats != null) {
            return this.lbStats;
        }
        if (this.rule != null) {
            ILoadBalancer lb = this.rule.getLoadBalancer();
            if (lb instanceof AbstractLoadBalancer) {
                LoadBalancerStats stats = ((AbstractLoadBalancer)lb).getLoadBalancerStats();
                this.setLoadBalancerStats(stats);
                return stats;
            }
            return null;
        }
        return null;
    }

    public void setLoadBalancerStats(LoadBalancerStats stats) {
        this.lbStats = stats;
    }

    public Predicate<Server> getServerOnlyPredicate() {
        return this.serverOnlyPredicate;
    }

    public List<Server> getEligibleServers(List<Server> servers) {
        return this.getEligibleServers(servers, null);
    }

    public List<Server> getEligibleServers(List<Server> servers, Object loadBalancerKey) {
        if (loadBalancerKey == null) {
            return ImmutableList.copyOf(Iterables.filter(servers, this.getServerOnlyPredicate()));
        }
        ArrayList<Server> results = Lists.newArrayList();
        for (Server server : servers) {
            if (!this.apply(new PredicateKey(loadBalancerKey, server))) continue;
            results.add(server);
        }
        return results;
    }

    public Optional<Server> chooseRandomlyAfterFiltering(List<Server> servers) {
        List<Server> eligible = this.getEligibleServers(servers);
        if (eligible.size() == 0) {
            return Optional.absent();
        }
        return Optional.of(eligible.get(this.random.nextInt(eligible.size())));
    }

    public Optional<Server> chooseRoundRobinAfterFiltering(List<Server> servers) {
        List<Server> eligible = this.getEligibleServers(servers);
        if (eligible.size() == 0) {
            return Optional.absent();
        }
        return Optional.of(eligible.get(this.nextIndex.getAndIncrement() % eligible.size()));
    }

    public Optional<Server> chooseRandomlyAfterFiltering(List<Server> servers, Object loadBalancerKey) {
        List<Server> eligible = this.getEligibleServers(servers, loadBalancerKey);
        if (eligible.size() == 0) {
            return Optional.absent();
        }
        return Optional.of(eligible.get(this.random.nextInt(eligible.size())));
    }

    public Optional<Server> chooseRoundRobinAfterFiltering(List<Server> servers, Object loadBalancerKey) {
        List<Server> eligible = this.getEligibleServers(servers, loadBalancerKey);
        if (eligible.size() == 0) {
            return Optional.absent();
        }
        return Optional.of(eligible.get(this.nextIndex.getAndIncrement() % eligible.size()));
    }

    public static AbstractServerPredicate ofKeyPredicate(final Predicate<PredicateKey> p) {
        return new AbstractServerPredicate(){

            @Override
            @SuppressWarnings(value={"NP"})
            public boolean apply(PredicateKey input) {
                return p.apply(input);
            }
        };
    }

    public static AbstractServerPredicate ofServerPredicate(final Predicate<Server> p) {
        return new AbstractServerPredicate(){

            @Override
            @SuppressWarnings(value={"NP"})
            public boolean apply(PredicateKey input) {
                return p.apply(input.getServer());
            }
        };
    }
}

