/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.loadbalancer;

import com.spotify.ffwd.http.netflix.loadbalancer.AbstractLoadBalancer;
import com.spotify.ffwd.http.netflix.loadbalancer.ClientConfigEnabledRoundRobinRule;
import com.spotify.ffwd.http.netflix.loadbalancer.ILoadBalancer;
import com.spotify.ffwd.http.netflix.loadbalancer.LoadBalancerStats;
import com.spotify.ffwd.http.netflix.loadbalancer.Server;
import com.spotify.ffwd.http.netflix.loadbalancer.ServerStats;
import java.util.List;

public class BestAvailableRule
extends ClientConfigEnabledRoundRobinRule {
    private LoadBalancerStats loadBalancerStats;

    @Override
    public Server choose(Object key) {
        if (this.loadBalancerStats == null) {
            return super.choose(key);
        }
        List<Server> serverList = this.getLoadBalancer().getAllServers();
        int minimalConcurrentConnections = Integer.MAX_VALUE;
        long currentTime = System.currentTimeMillis();
        Server chosen = null;
        for (Server server : serverList) {
            int concurrentConnections;
            ServerStats serverStats = this.loadBalancerStats.getSingleServerStat(server);
            if (serverStats.isCircuitBreakerTripped(currentTime) || (concurrentConnections = serverStats.getActiveRequestsCount(currentTime)) >= minimalConcurrentConnections) continue;
            minimalConcurrentConnections = concurrentConnections;
            chosen = server;
        }
        if (chosen == null) {
            return super.choose(key);
        }
        return chosen;
    }

    @Override
    public void setLoadBalancer(ILoadBalancer lb) {
        super.setLoadBalancer(lb);
        if (lb instanceof AbstractLoadBalancer) {
            this.loadBalancerStats = ((AbstractLoadBalancer)lb).getLoadBalancerStats();
        }
    }
}

