/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.loadbalancer;

import com.spotify.ffwd.http.google.common.base.Strings;
import com.spotify.ffwd.http.google.common.collect.Lists;
import com.spotify.ffwd.http.netflix.client.config.CommonClientConfigKey;
import com.spotify.ffwd.http.netflix.client.config.IClientConfig;
import com.spotify.ffwd.http.netflix.loadbalancer.AbstractServerList;
import com.spotify.ffwd.http.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationBasedServerList
extends AbstractServerList<Server> {
    private IClientConfig clientConfig;

    @Override
    public List<Server> getInitialListOfServers() {
        return this.getUpdatedListOfServers();
    }

    @Override
    public List<Server> getUpdatedListOfServers() {
        String listOfServers = this.clientConfig.get(CommonClientConfigKey.ListOfServers);
        return this.derive(listOfServers);
    }

    @Override
    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    private List<Server> derive(String value) {
        ArrayList<Server> list = Lists.newArrayList();
        if (!Strings.isNullOrEmpty(value)) {
            for (String s : value.split(",")) {
                list.add(new Server(s.trim()));
            }
        }
        return list;
    }
}

