/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.loadbalancer;

import com.spotify.ffwd.http.netflix.client.config.IClientConfig;
import com.spotify.ffwd.http.netflix.loadbalancer.AbstractLoadBalancerRule;
import com.spotify.ffwd.http.netflix.loadbalancer.ILoadBalancer;
import com.spotify.ffwd.http.netflix.loadbalancer.Server;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.List;
import java.util.Random;

public class RandomRule
extends AbstractLoadBalancerRule {
    Random rand = new Random();

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"})
    public Server choose(ILoadBalancer lb, Object key) {
        if (lb == null) {
            return null;
        }
        Server server = null;
        while (server == null) {
            if (Thread.interrupted()) {
                return null;
            }
            List<Server> upList = lb.getReachableServers();
            List<Server> allList = lb.getAllServers();
            int serverCount = allList.size();
            if (serverCount == 0) {
                return null;
            }
            int index = this.rand.nextInt(serverCount);
            server = upList.get(index);
            if (server == null) {
                Thread.yield();
                continue;
            }
            if (server.isAlive()) {
                return server;
            }
            server = null;
            Thread.yield();
        }
        return server;
    }

    @Override
    public Server choose(Object key) {
        return this.choose(this.getLoadBalancer(), key);
    }

    @Override
    public void initWithNiwsConfig(IClientConfig clientConfig) {
    }
}

