/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.loadbalancer;

import com.spotify.ffwd.http.netflix.client.config.IClientConfig;
import com.spotify.ffwd.http.netflix.loadbalancer.AbstractServerPredicate;
import com.spotify.ffwd.http.netflix.loadbalancer.AvailabilityPredicate;
import com.spotify.ffwd.http.netflix.loadbalancer.CompositePredicate;
import com.spotify.ffwd.http.netflix.loadbalancer.LoadBalancerStats;
import com.spotify.ffwd.http.netflix.loadbalancer.PredicateBasedRule;
import com.spotify.ffwd.http.netflix.loadbalancer.ZoneAvoidancePredicate;
import com.spotify.ffwd.http.netflix.loadbalancer.ZoneSnapshot;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class ZoneAvoidanceRule
extends PredicateBasedRule {
    private static final Random random = new Random();
    private CompositePredicate compositePredicate;

    public ZoneAvoidanceRule() {
        ZoneAvoidancePredicate zonePredicate = new ZoneAvoidancePredicate(this);
        AvailabilityPredicate availabilityPredicate = new AvailabilityPredicate(this);
        this.compositePredicate = this.createCompositePredicate(zonePredicate, availabilityPredicate);
    }

    private CompositePredicate createCompositePredicate(ZoneAvoidancePredicate p1, AvailabilityPredicate p2) {
        return CompositePredicate.withPredicates(p1, p2).addFallbackPredicate(p2).addFallbackPredicate(AbstractServerPredicate.alwaysTrue()).build();
    }

    @Override
    public void initWithNiwsConfig(IClientConfig clientConfig) {
        ZoneAvoidancePredicate zonePredicate = new ZoneAvoidancePredicate(this, clientConfig);
        AvailabilityPredicate availabilityPredicate = new AvailabilityPredicate(this, clientConfig);
        this.compositePredicate = this.createCompositePredicate(zonePredicate, availabilityPredicate);
    }

    static Map<String, ZoneSnapshot> createSnapshot(LoadBalancerStats lbStats) {
        HashMap<String, ZoneSnapshot> map = new HashMap<String, ZoneSnapshot>();
        for (String zone : lbStats.getAvailableZones()) {
            ZoneSnapshot snapshot = lbStats.getZoneSnapshot(zone);
            map.put(zone, snapshot);
        }
        return map;
    }

    static String randomChooseZone(Map<String, ZoneSnapshot> snapshot, Set<String> chooseFrom) {
        if (chooseFrom == null || chooseFrom.size() == 0) {
            return null;
        }
        String selectedZone = chooseFrom.iterator().next();
        if (chooseFrom.size() == 1) {
            return selectedZone;
        }
        int totalServerCount = 0;
        for (String zone : chooseFrom) {
            totalServerCount += snapshot.get(zone).getInstanceCount();
        }
        int index = random.nextInt(totalServerCount) + 1;
        int sum = 0;
        for (String zone : chooseFrom) {
            if (index > (sum += snapshot.get(zone).getInstanceCount())) continue;
            selectedZone = zone;
            break;
        }
        return selectedZone;
    }

    public static Set<String> getAvailableZones(Map<String, ZoneSnapshot> snapshot, double triggeringLoad, double triggeringBlackoutPercentage) {
        if (snapshot.isEmpty()) {
            return null;
        }
        HashSet<String> availableZones = new HashSet<String>(snapshot.keySet());
        if (availableZones.size() == 1) {
            return availableZones;
        }
        HashSet<String> worstZones = new HashSet<String>();
        double maxLoadPerServer = 0.0;
        boolean limitedZoneAvailability = false;
        for (Map.Entry<String, ZoneSnapshot> zoneEntry : snapshot.entrySet()) {
            String zone = zoneEntry.getKey();
            ZoneSnapshot zoneSnapshot = zoneEntry.getValue();
            int instanceCount = zoneSnapshot.getInstanceCount();
            if (instanceCount == 0) {
                availableZones.remove(zone);
                limitedZoneAvailability = true;
                continue;
            }
            double loadPerServer = zoneSnapshot.getLoadPerServer();
            if ((double)zoneSnapshot.getCircuitTrippedCount() / (double)instanceCount >= triggeringBlackoutPercentage || loadPerServer < 0.0) {
                availableZones.remove(zone);
                limitedZoneAvailability = true;
                continue;
            }
            if (Math.abs(loadPerServer - maxLoadPerServer) < 1.0E-6) {
                worstZones.add(zone);
                continue;
            }
            if (!(loadPerServer > maxLoadPerServer)) continue;
            maxLoadPerServer = loadPerServer;
            worstZones.clear();
            worstZones.add(zone);
        }
        if (maxLoadPerServer < triggeringLoad && !limitedZoneAvailability) {
            return availableZones;
        }
        String zoneToAvoid = ZoneAvoidanceRule.randomChooseZone(snapshot, worstZones);
        if (zoneToAvoid != null) {
            availableZones.remove(zoneToAvoid);
        }
        return availableZones;
    }

    public static Set<String> getAvailableZones(LoadBalancerStats lbStats, double triggeringLoad, double triggeringBlackoutPercentage) {
        if (lbStats == null) {
            return null;
        }
        Map<String, ZoneSnapshot> snapshot = ZoneAvoidanceRule.createSnapshot(lbStats);
        return ZoneAvoidanceRule.getAvailableZones(snapshot, triggeringLoad, triggeringBlackoutPercentage);
    }

    @Override
    public AbstractServerPredicate getPredicate() {
        return this.compositePredicate;
    }
}

