/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.loadbalancer;

import com.spotify.ffwd.http.netflix.loadbalancer.LoadBalancerStats;
import com.spotify.ffwd.http.netflix.loadbalancer.Server;
import com.spotify.ffwd.http.netflix.loadbalancer.ZoneSnapshot;
import com.spotify.ffwd.http.netflix.servo.annotations.DataSourceType;
import com.spotify.ffwd.http.netflix.servo.annotations.Monitor;
import com.spotify.ffwd.http.netflix.servo.monitor.Counter;
import com.spotify.ffwd.http.netflix.servo.monitor.Monitors;

public class ZoneStats<T extends Server> {
    private final LoadBalancerStats loadBalancerStats;
    private final String zone;
    private static final String PREFIX = "ZoneStats_";
    private final Counter counter;
    final String monitorId;

    public ZoneStats(String name, String zone, LoadBalancerStats loadBalancerStats) {
        this.zone = zone;
        this.loadBalancerStats = loadBalancerStats;
        this.monitorId = name + ":" + zone;
        this.counter = Monitors.newCounter(PREFIX + name + "_" + zone + "_Counter");
        Monitors.registerObject(this.monitorId, this);
    }

    public final String getZone() {
        return this.zone;
    }

    @Monitor(name="ZoneStats_ActiveRequestsCount", type=DataSourceType.INFORMATIONAL)
    public int getActiveRequestsCount() {
        return this.loadBalancerStats.getActiveRequestsCount(this.zone);
    }

    @Monitor(name="ZoneStats_InstanceCount", type=DataSourceType.GAUGE)
    public int getInstanceCount() {
        return this.loadBalancerStats.getInstanceCount(this.zone);
    }

    @Monitor(name="ZoneStats_CircuitBreakerTrippedCount", type=DataSourceType.GAUGE)
    public int getCircuitBreakerTrippedCount() {
        return this.loadBalancerStats.getCircuitBreakerTrippedCount(this.zone);
    }

    @Monitor(name="ZoneStats_ActiveRequestsPerServer", type=DataSourceType.GAUGE)
    public double getActiveRequestsPerServer() {
        return this.loadBalancerStats.getActiveRequestsPerServer(this.zone);
    }

    public long getMeasuredZoneHits() {
        return this.loadBalancerStats.getMeasuredZoneHits(this.zone);
    }

    @Monitor(name="ZoneStats_CircuitBreakerTrippedPercentage", type=DataSourceType.INFORMATIONAL)
    public double getCircuitBreakerTrippedPercentage() {
        ZoneSnapshot snapShot = this.loadBalancerStats.getZoneSnapshot(this.zone);
        int totalCount = snapShot.getInstanceCount();
        int circuitTrippedCount = snapShot.getCircuitTrippedCount();
        if (totalCount == 0) {
            if (circuitTrippedCount != 0) {
                return -1.0;
            }
            return 0.0;
        }
        return (double)snapShot.getCircuitTrippedCount() / (double)totalCount;
    }

    void incrementCounter() {
        this.counter.increment();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Zone:" + this.zone + ";");
        sb.append("\tInstance count:" + this.getInstanceCount() + ";");
        sb.append("\tActive connections count: " + this.getActiveRequestsCount() + ";");
        sb.append("\tCircuit breaker tripped count: " + this.getCircuitBreakerTrippedCount() + ";");
        sb.append("\tActive connections per server: " + this.getActiveRequestsPerServer() + ";");
        sb.append("]\n");
        return sb.toString();
    }
}

