/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.loadbalancer.reactive;

import com.spotify.ffwd.http.netflix.client.RetryHandler;
import com.spotify.ffwd.http.netflix.client.config.IClientConfig;
import com.spotify.ffwd.http.netflix.client.config.IClientConfigKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExecutionContext<T> {
    private final Map<String, Object> context;
    private final ConcurrentHashMap<Object, ChildContext<T>> subContexts;
    private final T request;
    private final IClientConfig requestConfig;
    private final RetryHandler retryHandler;
    private final IClientConfig clientConfig;

    public ExecutionContext(T request, IClientConfig requestConfig, IClientConfig clientConfig, RetryHandler retryHandler) {
        this.request = request;
        this.requestConfig = requestConfig;
        this.clientConfig = clientConfig;
        this.context = new ConcurrentHashMap<String, Object>();
        this.subContexts = new ConcurrentHashMap();
        this.retryHandler = retryHandler;
    }

    ExecutionContext(T request, IClientConfig requestConfig, IClientConfig clientConfig, RetryHandler retryHandler, ConcurrentHashMap<Object, ChildContext<T>> subContexts) {
        this.request = request;
        this.requestConfig = requestConfig;
        this.clientConfig = clientConfig;
        this.context = new ConcurrentHashMap<String, Object>();
        this.subContexts = subContexts;
        this.retryHandler = retryHandler;
    }

    ExecutionContext<T> getChildContext(Object obj) {
        ChildContext<T> old;
        if (this.subContexts == null) {
            return null;
        }
        ChildContext<T> subContext = this.subContexts.get(obj);
        if (subContext == null && (old = this.subContexts.putIfAbsent(obj, subContext = new ChildContext(this))) != null) {
            subContext = old;
        }
        return subContext;
    }

    public T getRequest() {
        return this.request;
    }

    public Object get(String name) {
        return this.context.get(name);
    }

    public <S> S getClientProperty(IClientConfigKey<S> key) {
        S value;
        if (this.requestConfig != null && (value = this.requestConfig.get(key)) != null) {
            return value;
        }
        value = this.clientConfig.get(key);
        return value;
    }

    public void put(String name, Object value) {
        this.context.put(name, value);
    }

    public IClientConfig getRequestConfig() {
        return this.requestConfig;
    }

    public ExecutionContext<T> getGlobalContext() {
        return this;
    }

    public RetryHandler getRetryHandler() {
        return this.retryHandler;
    }

    private static class ChildContext<T>
    extends ExecutionContext<T> {
        private final ExecutionContext<T> parent;

        ChildContext(ExecutionContext<T> parent) {
            super(((ExecutionContext)parent).request, ((ExecutionContext)parent).requestConfig, ((ExecutionContext)parent).clientConfig, ((ExecutionContext)parent).retryHandler, null);
            this.parent = parent;
        }

        @Override
        public ExecutionContext<T> getGlobalContext() {
            return this.parent;
        }
    }
}

