/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.loadbalancer.reactive;

import com.spotify.ffwd.http.netflix.client.ClientException;
import com.spotify.ffwd.http.netflix.client.RetryHandler;
import com.spotify.ffwd.http.netflix.client.config.IClientConfig;
import com.spotify.ffwd.http.netflix.loadbalancer.ILoadBalancer;
import com.spotify.ffwd.http.netflix.loadbalancer.LoadBalancerContext;
import com.spotify.ffwd.http.netflix.loadbalancer.Server;
import com.spotify.ffwd.http.netflix.loadbalancer.ServerStats;
import com.spotify.ffwd.http.netflix.loadbalancer.reactive.ExecutionContext;
import com.spotify.ffwd.http.netflix.loadbalancer.reactive.ExecutionContextListenerInvoker;
import com.spotify.ffwd.http.netflix.loadbalancer.reactive.ExecutionInfo;
import com.spotify.ffwd.http.netflix.loadbalancer.reactive.ExecutionListener;
import com.spotify.ffwd.http.netflix.loadbalancer.reactive.ServerOperation;
import com.spotify.ffwd.http.netflix.servo.monitor.Stopwatch;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Func1;
import rx.functions.Func2;

public class LoadBalancerCommand<T> {
    private static final Logger logger = LoggerFactory.getLogger(LoadBalancerCommand.class);
    private final URI loadBalancerURI;
    private final Object loadBalancerKey;
    private final LoadBalancerContext loadBalancerContext;
    private final RetryHandler retryHandler;
    private volatile ExecutionInfo executionInfo;
    private final Server server;
    private final ExecutionContextListenerInvoker<?, T> listenerInvoker;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private LoadBalancerCommand(Builder<T> builder) {
        this.loadBalancerURI = ((Builder)builder).loadBalancerURI;
        this.loadBalancerKey = ((Builder)builder).loadBalancerKey;
        this.loadBalancerContext = ((Builder)builder).loadBalancerContext;
        this.retryHandler = ((Builder)builder).retryHandler != null ? ((Builder)builder).retryHandler : this.loadBalancerContext.getRetryHandler();
        this.listenerInvoker = ((Builder)builder).invoker;
        this.server = ((Builder)builder).server;
    }

    private Observable<Server> selectServer() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Server>(){

            public void call(Subscriber<? super Server> next) {
                try {
                    Server server = LoadBalancerCommand.this.loadBalancerContext.getServerFromLoadBalancer(LoadBalancerCommand.this.loadBalancerURI, LoadBalancerCommand.this.loadBalancerKey);
                    next.onNext((Object)server);
                    next.onCompleted();
                }
                catch (Exception e) {
                    next.onError((Throwable)e);
                }
            }
        });
    }

    private Func2<Integer, Throwable, Boolean> retryPolicy(final int maxRetrys, final boolean same) {
        return new Func2<Integer, Throwable, Boolean>(){

            public Boolean call(Integer tryCount, Throwable e) {
                if (e instanceof ExecutionListener.AbortExecutionException) {
                    return false;
                }
                if (tryCount > maxRetrys) {
                    return false;
                }
                if (e.getCause() != null && e instanceof RuntimeException) {
                    e = e.getCause();
                }
                return LoadBalancerCommand.this.retryHandler.isRetriableException(e, same);
            }
        };
    }

    public Observable<T> submit(final ServerOperation<T> operation) {
        final ExecutionInfoContext context = new ExecutionInfoContext();
        if (this.listenerInvoker != null) {
            try {
                this.listenerInvoker.onExecutionStart();
            }
            catch (ExecutionListener.AbortExecutionException e) {
                return Observable.error((Throwable)e);
            }
        }
        final int maxRetrysSame = this.retryHandler.getMaxRetriesOnSameServer();
        final int maxRetrysNext = this.retryHandler.getMaxRetriesOnNextServer();
        Observable o = (this.server == null ? this.selectServer() : Observable.just((Object)this.server)).concatMap(new Func1<Server, Observable<T>>(){

            public Observable<T> call(Server server) {
                context.setServer(server);
                final ServerStats stats = LoadBalancerCommand.this.loadBalancerContext.getServerStats(server);
                Observable o = Observable.just((Object)server).concatMap(new Func1<Server, Observable<T>>(){

                    public Observable<T> call(final Server server) {
                        context.incAttemptCount();
                        LoadBalancerCommand.this.loadBalancerContext.noteOpenConnection(stats);
                        if (LoadBalancerCommand.this.listenerInvoker != null) {
                            try {
                                LoadBalancerCommand.this.listenerInvoker.onStartWithServer(context.toExecutionInfo());
                            }
                            catch (ExecutionListener.AbortExecutionException e) {
                                return Observable.error((Throwable)e);
                            }
                        }
                        final Stopwatch tracer = LoadBalancerCommand.this.loadBalancerContext.getExecuteTracer().start();
                        return operation.call(server).doOnEach(new Observer<T>(){
                            private T entity;

                            public void onCompleted() {
                                this.recordStats(tracer, stats, this.entity, null);
                            }

                            public void onError(Throwable e) {
                                this.recordStats(tracer, stats, null, e);
                                logger.debug("Got error {} when executed on server {}", (Object)e, (Object)server);
                                if (LoadBalancerCommand.this.listenerInvoker != null) {
                                    LoadBalancerCommand.this.listenerInvoker.onExceptionWithServer(e, context.toExecutionInfo());
                                }
                            }

                            public void onNext(T entity) {
                                this.entity = entity;
                                if (LoadBalancerCommand.this.listenerInvoker != null) {
                                    LoadBalancerCommand.this.listenerInvoker.onExecutionSuccess(entity, context.toExecutionInfo());
                                }
                            }

                            private void recordStats(Stopwatch tracer2, ServerStats stats, Object entity, Throwable exception) {
                                tracer2.stop();
                                LoadBalancerCommand.this.loadBalancerContext.noteRequestCompletion(stats, entity, exception, tracer2.getDuration(TimeUnit.MILLISECONDS), LoadBalancerCommand.this.retryHandler);
                            }
                        });
                    }
                });
                if (maxRetrysSame > 0) {
                    o = o.retry(LoadBalancerCommand.this.retryPolicy(maxRetrysSame, true));
                }
                return o;
            }
        });
        if (maxRetrysNext > 0 && this.server == null) {
            o = o.retry(this.retryPolicy(maxRetrysNext, false));
        }
        return o.onErrorResumeNext(new Func1<Throwable, Observable<T>>(){

            public Observable<T> call(Throwable e) {
                if (context.getAttemptCount() > 0) {
                    if (maxRetrysNext > 0 && context.getServerAttemptCount() == maxRetrysNext + 1) {
                        e = new ClientException(ClientException.ErrorType.NUMBEROF_RETRIES_NEXTSERVER_EXCEEDED, "Number of retries on next server exceeded max " + maxRetrysNext + " retries, while making a call for: " + context.getServer(), e);
                    } else if (maxRetrysSame > 0 && context.getAttemptCount() == maxRetrysSame + 1) {
                        e = new ClientException(ClientException.ErrorType.NUMBEROF_RETRIES_EXEEDED, "Number of retries exceeded max " + maxRetrysSame + " retries, while making a call for: " + context.getServer(), e);
                    }
                }
                if (LoadBalancerCommand.this.listenerInvoker != null) {
                    LoadBalancerCommand.this.listenerInvoker.onExecutionFailed(e, context.toFinalExecutionInfo());
                }
                return Observable.error((Throwable)e);
            }
        });
    }

    class ExecutionInfoContext {
        Server server;
        int serverAttemptCount = 0;
        int attemptCount = 0;

        ExecutionInfoContext() {
        }

        public void setServer(Server server) {
            this.server = server;
            ++this.serverAttemptCount;
            this.attemptCount = 0;
        }

        public void incAttemptCount() {
            ++this.attemptCount;
        }

        public int getAttemptCount() {
            return this.attemptCount;
        }

        public Server getServer() {
            return this.server;
        }

        public int getServerAttemptCount() {
            return this.serverAttemptCount;
        }

        public ExecutionInfo toExecutionInfo() {
            return ExecutionInfo.create(this.server, this.attemptCount - 1, this.serverAttemptCount - 1);
        }

        public ExecutionInfo toFinalExecutionInfo() {
            return ExecutionInfo.create(this.server, this.attemptCount, this.serverAttemptCount - 1);
        }
    }

    public static class Builder<T> {
        private RetryHandler retryHandler;
        private ILoadBalancer loadBalancer;
        private IClientConfig config;
        private LoadBalancerContext loadBalancerContext;
        private List<? extends ExecutionListener<?, T>> listeners;
        private Object loadBalancerKey;
        private ExecutionContext<?> executionContext;
        private ExecutionContextListenerInvoker invoker;
        private URI loadBalancerURI;
        private Server server;

        private Builder() {
        }

        public Builder<T> withLoadBalancer(ILoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        public Builder<T> withLoadBalancerURI(URI loadBalancerURI) {
            this.loadBalancerURI = loadBalancerURI;
            return this;
        }

        public Builder<T> withListeners(List<? extends ExecutionListener<?, T>> listeners) {
            if (this.listeners == null) {
                this.listeners = new LinkedList(listeners);
            } else {
                this.listeners.addAll(listeners);
            }
            return this;
        }

        public Builder<T> withRetryHandler(RetryHandler retryHandler) {
            this.retryHandler = retryHandler;
            return this;
        }

        public Builder<T> withClientConfig(IClientConfig config) {
            this.config = config;
            return this;
        }

        public Builder<T> withServerLocator(Object key) {
            this.loadBalancerKey = key;
            return this;
        }

        public Builder<T> withLoadBalancerContext(LoadBalancerContext loadBalancerContext) {
            this.loadBalancerContext = loadBalancerContext;
            return this;
        }

        public Builder<T> withExecutionContext(ExecutionContext<?> executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        public Builder<T> withServer(Server server) {
            this.server = server;
            return this;
        }

        public LoadBalancerCommand<T> build() {
            if (this.loadBalancerContext == null && this.loadBalancer == null) {
                throw new IllegalArgumentException("Either LoadBalancer or LoadBalancerContext needs to be set");
            }
            if (this.listeners != null && this.listeners.size() > 0) {
                this.invoker = new ExecutionContextListenerInvoker(this.executionContext, this.listeners, this.config);
            }
            if (this.loadBalancerContext == null) {
                this.loadBalancerContext = new LoadBalancerContext(this.loadBalancer, this.config);
            }
            return new LoadBalancerCommand(this);
        }
    }
}

