/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo;

import com.spotify.ffwd.http.netflix.servo.MonitorRegistry;
import com.spotify.ffwd.http.netflix.servo.monitor.Monitor;
import com.spotify.ffwd.http.netflix.servo.util.Preconditions;
import com.spotify.ffwd.http.netflix.servo.util.UnmodifiableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class BasicMonitorRegistry
implements MonitorRegistry {
    private final Set<Monitor<?>> monitors = Collections.synchronizedSet(new HashSet());

    @Override
    public Collection<Monitor<?>> getRegisteredMonitors() {
        return UnmodifiableList.copyOf(this.monitors);
    }

    @Override
    public void register(Monitor<?> monitor) {
        Preconditions.checkNotNull(monitor, "monitor");
        try {
            this.monitors.add(monitor);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid object", e);
        }
    }

    @Override
    public void unregister(Monitor<?> monitor) {
        Preconditions.checkNotNull(monitor, "monitor");
        try {
            this.monitors.remove(monitor);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid object", e);
        }
    }

    @Override
    public boolean isRegistered(Monitor<?> monitor) {
        return this.monitors.contains(monitor);
    }
}

