/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo;

import com.spotify.ffwd.http.netflix.servo.monitor.MonitorConfig;
import com.spotify.ffwd.http.netflix.servo.tag.TagList;
import com.spotify.ffwd.http.netflix.servo.util.Preconditions;

public final class Metric {
    private final MonitorConfig config;
    private final long timestamp;
    private final Object value;

    public Metric(String name, TagList tags, long timestamp, Object value) {
        this(new MonitorConfig.Builder(name).withTags(tags).build(), timestamp, value);
    }

    public Metric(MonitorConfig config, long timestamp, Object value) {
        this.config = Preconditions.checkNotNull(config, "config");
        this.timestamp = timestamp;
        this.value = Preconditions.checkNotNull(value, "value");
    }

    public MonitorConfig getConfig() {
        return this.config;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public Number getNumberValue() {
        return (Number)this.value;
    }

    public boolean hasNumberValue() {
        return this.value instanceof Number;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Metric)) {
            return false;
        }
        Metric m = (Metric)obj;
        return this.config.equals(m.getConfig()) && this.timestamp == m.getTimestamp() && this.value.equals(m.getValue());
    }

    public int hashCode() {
        int result = this.config.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "Metric{config=" + this.config + ", timestamp=" + this.timestamp + ", value=" + this.value + '}';
    }
}

