/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.ffwd.http.netflix.servo.jmx;

import com.spotify.ffwd.http.netflix.servo.tag.Tag;
import com.spotify.ffwd.http.netflix.servo.tag.TagList;
import com.spotify.ffwd.http.netflix.servo.util.Throwables;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ObjectNameBuilder {
    private static final Pattern INVALID_CHARS = Pattern.compile("[^a-zA-Z0-9_\\-\\.]");
    private static final Logger LOG = LoggerFactory.getLogger(ObjectNameBuilder.class);
    private final StringBuilder nameStrBuilder;

    public static String sanitizeValue(String value) {
        return INVALID_CHARS.matcher(value).replaceAll("_");
    }

    public static ObjectNameBuilder forDomain(String domain) {
        return new ObjectNameBuilder(domain);
    }

    private ObjectNameBuilder(String domain) {
        this.nameStrBuilder = new StringBuilder(ObjectNameBuilder.sanitizeValue(domain));
        this.nameStrBuilder.append(":");
    }

    public ObjectNameBuilder addProperties(TagList tagList) {
        for (Tag tag : tagList) {
            this.addProperty(tag);
        }
        return this;
    }

    public ObjectNameBuilder addProperty(Tag tag) {
        return this.addProperty(tag.getKey(), tag.getValue());
    }

    public ObjectNameBuilder addProperty(String key, String value) {
        this.nameStrBuilder.append(ObjectNameBuilder.sanitizeValue(key)).append('=').append(ObjectNameBuilder.sanitizeValue(value)).append(",");
        return this;
    }

    public ObjectName build() {
        String name = this.nameStrBuilder.substring(0, this.nameStrBuilder.length() - 1);
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Invalid ObjectName provided: " + name);
            throw Throwables.propagate(e);
        }
    }
}

